# install

## Requirement
Python 3.9
PyTorch 1.12.1
CUDA 11.4

conda create -n conpe python=3.9

conda activate conpe

install pytorch proper version

conda install pytorch==1.12.1 torchvision==0.13.1 torchaudio==0.12.1 cudatoolkit=11.3 -c pytorch

conda install pytorch==1.12.1 torchvision==0.13.1 torchaudio==0.12.1 cudatoolkit=11.6 -c pytorch -c conda-forge

pip install torch==1.13.0+cu117 torchvision==0.14.0+cu117 torchaudio==0.13.0 --extra-index-url https://download.pytorch.org/whl/cu117

pip install git+https://github.com/openai/CLIP.git

pip install -r requirements_repre.txt

pip install -r requirements_pol.txt

## Dataset Download

mkdir trajdata

cd trajdata

download dataset from  https://drive.google.com/file/d/1S8-2g5VzoB-Kd4rjCsLpqPjSwKsT5aGV/view?usp=share_link and https://drive.google.com/file/d/1H7tsZoNNFyKszmJCWZvpu4bNtxix937n/view?usp=share_link, and then unompress it.


# AI2THOR

## Data Generation

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python allenact/main.py  -b projects/object_navigation/baseline_configs/ithor/  objectnav_ithor_data_generator  -c pretrained_model_ckpts/robothor-objectnav-challenge-2021/Objectnav-RoboTHOR-RGBD-ResNetGRU-DDPPO/2021-02-09_22-35-15/exp_Objectnav-RoboTHOR-RGBD-ResNetGRU-DDPPO_0.2.0a_300M__stage_00__steps_000170207237.pt --eval

python AI2THOR/dataset_refinement_AI2THOR.py  allenact/datasets/expert_data_gen/ --factor FOV

## Representation Learning

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python AI2THOR/Method_Visual_Contrastive_AI2THOR.py  trajdata/ObjNav/original/  -d IthorLoader -s 10mdps -t 2mdps -a CLIPViT-B/32 --seed 777 --log logs/log_name/ --model-cls VPTCLIP --epochs 500 --batch-size 256 --objective contrastive

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python AI2THOR/Method_TemporalAction_Contrastive_AI2THOR.py  trajdata/ObjNav/original/FOV/train_dataset.pkl  -a CLIPViT-B/32 --seed 777 --log logs/log_name/ --model-cls VPTCLIP --epochs 200 --objective comparative --contrastive-task action_byol --batch-size 64

## Text Prompt Learning

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python AI2THOR/Method_TextPromptLearning_AI2THOR.py  trajdata/ObjNav/original/ -d IthorLoaderText -s 10mdps -t 2mdps -a CLIPViT-B/32 --seed 777 --log logs/log_name/ --model-cls MVLPTCLIP --epochs 500 --batch-size 256

### prompt analysis

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python AI2THOR/Method_TextPromptLearning_AI2THOR.py  trajdata/ObjNav/original/ -d IthorLoaderText -s 10mdps -t 2mdps -a CLIPViT-B/32 --seed 777 --log logs/log_name/ --model-cls MVLPTCLIP --epochs 0 --batch-size 1 --phase analysis

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python AI2THOR/Method_TextPromptLearning_AI2THOR.py  trajdata/ObjNav/original/ -d IthorLoaderText -s 10mdps -t 2mdps -a CLIPViT-B/32 --seed 777 --log logs/log_name/ --model-cls MVLPTCLIP --epochs 500 --batch-size 256 --phase test --ckpt-path logs/10promptcls_csc/checkpoints/best.pth

## Agent Learning

cd allenact

download dataset from https://drive.google.com/file/d/1PJtNnoe67uhS39V2QuO74ancCqgF_7w9/view?usp=share_link, and then unompress it.

### Source task

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python allenact/main.py -o storage/log_name -b projects/object_navigation/baseline_configs/ithor/clip objectnav_ithor_rgb_conpe_gru_ddppo_mdps

bash autotest.sh objectnav_ithor_rgb_conpe_gru_ddppo_autotest storage/path/to/model

### different task

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python allenact/main.py -o storage/log_name -b projects/point_navigation/baseline_configs/ithor/clip pointnav_ithor_rgb_clip_vit32gru_ddppo_mdps

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python allenact/main.py -o storage/log_name -b projects/image_navigation/baseline_configs/ithor/clip imagenav_ithor_rgb_clip_vit32gru_ddppo_mdps

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=$PYTHONPATH:"../.." allenact -o rearrange_out -b . baseline_configs/one_phase/one_phase_rgb_clipViT_dagger.py



# METAWORLD

## Data Generation

CUDA_VISIBLE_DEVICES=0 python METAWORLD/dataset_refinement_METAWORLD.py /path/to/dataset/drawer-close/ --factor FOV --K 3 --out-dir trajdata/RoboMani/original/camera/ --file-name train_dataset.pkl

## Representation Learning

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python METAWORLD/Method_Visual_Contrastive_METAWORLD.py  trajdata/RoboMani/window-open/  -d MetaworldLoader -s 10mdps -t 2mdps -a CLIPViT-B/32 --seed 777 --log logs/log_name/ --model-cls VPTCLIP --epochs 1000 --batch-size 64 --objective contrastive

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python METAWORLD/Method_TemporalAction_Contrastive_METAWORLD.py  trajdata/RoboMani/window-open/CAMS/train_dataset.pkl  -a CLIPViT-B/32 --seed 777 --log logs/Robomani/ --model-cls VPTCLIP --epochs 200 --objective comparative --contrastive-task action_byol --batch-size 64

## Agent Learning

python main_bc.py --env reach-v2 --terminate --source --tag conpe --train --eval

python main_bc.py --env reach-v2 --terminate --source --tag conpe --eval --eval_seen_random

python main_bc.py --env reach-v2 --terminate --source --tag conpe --eval --eval_unseen_random


# COMPARISONS

## CURL

bash run_ai2thor.sh

## ATC

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python conpe_atc/atc.py  trajdata/ObjNav/original/ --dataset ai2thor  -a CLIPViT-B/32 --seed 777 --log logs/log_name/ --model-cls VPTCLIP --epochs 200 --objective comparative --contrastive-task action_byol --batch-size 64

## ACO

CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python acp/acp.py  trajdata/ObjNav/original/ --dataset ai2thor  -a CLIPViT-B/32 --seed 777 --log logs/log_name/ --model-cls VPTCLIP --epochs 200 --objective comparative --contrastive-task action_byol --batch-size 64


# For CARLA EXPERIMENTS

download https://drive.google.com/file/d/1uaugZSird6AuSNb8n-ZNb0tWCLLHwGeQ/view?usp=share_link, and then unompress it.