from baseline_configs.one_phase.one_phase_rgb_il_base import (
    OnePhaseRGBILBaseExperimentConfig,
)


class OnePhaseRGBClipResNet50DaggerExperimentConfig(OnePhaseRGBILBaseExperimentConfig):
    CNN_PREPROCESSOR_TYPE_AND_PRETRAINING = ("ViT-B/32", "clip")
    IL_PIPELINE_TYPE = "40proc"
    
    NOISE_STD = 0.0
    PROMPT = None
    MODEL="embclip"

    STEP_SIZE =             [0.1, 0.15]
    # ROTATION_DEGREES =      [90.0, 60.0, 30.0, 10.0]
    # VISIBILITY_DISTANCE =   [1.0 , 1.0, 1.0, 1.0]
    # LIGHTING_VALUE =        [(0.6, 0.2, 1.5, -0.4), (1.1, 1.0, 0.5, -0.1), None, (2.0, 3.5, 2, 0.4)]
    # HORIZONTAL_FIELD_OF_VIEW = [59, 69, 79, 99]
    # LOOK_DEGREES = [40, 10, 30, 20]

    @classmethod
    def tag(cls) -> str:
        return f"OnePhaseRGBTaskClipViT32Dagger_{cls.IL_PIPELINE_TYPE}_Noise002"
