from abc import ABC
from typing import Optional, Sequence

from allenact.base_abstractions.experiment_config import ExperimentConfig
from allenact.base_abstractions.sensor import Sensor


class PointNavBaseConfig(ExperimentConfig, ABC):
    """An Object Navigation experiment configuration in iThor."""

    ADVANCE_SCENE_ROLLOUT_PERIOD: Optional[int] = None
    SENSORS: Optional[Sequence[Sensor]] = None

    # STEP_SIZE = 0.25
    # ROTATION_DEGREES = 30.0
    # DISTANCE_TO_GOAL = 0.2
    DISTANCE_TO_GOAL = 1.5
    STOCHASTIC = True

    CAMERA_WIDTH = 400
    CAMERA_HEIGHT = 300
    SCREEN_SIZE = 224
    MAX_STEPS = 500

    def __init__(self):
        self.REWARD_CONFIG = {
            "step_penalty": -0.01,
            "goal_success_reward": 10.0,
            "failed_stop_reward": 0.0,
            "reached_max_steps_reward": 0.0,
            "shaping_weight": 1.0,
        }


class PointNavMultiMDPsBaseConfig(ExperimentConfig, ABC):
    """An Object Navigation experiment configuration in iThor."""

    ADVANCE_SCENE_ROLLOUT_PERIOD: Optional[int] = None
    SENSORS: Optional[Sequence[Sensor]] = None

    # STEP_SIZE = 0.25
    # ROTATION_DEGREES = 30.0
    # DISTANCE_TO_GOAL = 0.2
    DISTANCE_TO_GOAL = 1.5
    STOCHASTIC = True

    CAMERA_WIDTH = 400
    CAMERA_HEIGHT = 300
    SCREEN_SIZE = 224
    MAX_STEPS = 500

    def __init__(self):
        self.REWARD_CONFIG = {
            "step_penalty": -0.01,
            "goal_success_reward": 10.0,
            "failed_stop_reward": 0.0,
            "reached_max_steps_reward": 0.0,
            "shaping_weight": 1.0,
        }


class PointNavAUTOTESTBaseConfig(ExperimentConfig, ABC):
    """The base object navigation configuration file."""

    base_mdp_configs = {
        # SOURCE ENV
        "SMDP1": {
            "step_size": 0.1,
            "rotation_degrees": 90.0,
            "visibility_distance": 1,
            "lighting_value": (0.6, 0.2, 1.5, -0.4),
            "fov": 59,
            "look_degrees": 40,
        },
        "SMDP2": {
            "step_size": 0.15,
            "rotation_degrees": 60.0,
            "visibility_distance": 1,
            "lighting_value": (1.1, 1.0, 0.5, -0.1),
            "fov": 69,
            "look_degrees": 10,
        },
        "SMDP3": {
            "step_size": 0.25,
            "rotation_degrees": 30.0,
            "visibility_distance": 1,
            "lighting_value": None,
            "fov": 79,
            "look_degrees": 30,
        },
        "SMDP4": {
            "step_size": 0.3,
            "rotation_degrees": 10.0,
            "visibility_distance": 1,
            "lighting_value": (2.0, 3.5, 2, 0.4),
            "fov": 89,
            "look_degrees": 20,
        },
        # SEEN TARGET
        "STMDP1": {
            "step_size": 0.2,
            "rotation_degrees": 30,
            "visibility_distance": 1,
            "lighting_value": (0.9, None, None, None),
            "fov": 49,
            "look_degrees": 30.0,
        },
        "STMDP2": {
            "step_size": 0.25,
            "rotation_degrees": 30,
            "visibility_distance": 1,
            "lighting_value": (1.8, None, None, None),
            "fov": 59,
            "look_degrees": 45,
        },
        "STMDP3": {
            "step_size": 0.35,
            "rotation_degrees": 15,
            "visibility_distance": 1,
            "lighting_value": (None, 1.4, None, None),
            "fov": 59,
            "look_degrees": 40,
        },
        "STMDP4": {
            "step_size": 0.3,
            "rotation_degrees": 10,
            "visibility_distance": 1,
            "lighting_value": (None, 1.2, None, None),
            "fov": 69,
            "look_degrees": 35,
        },
        "STMDP5": {
            "step_size": 0.15,
            "rotation_degrees": 10,
            "visibility_distance": 1,
            "lighting_value": (None, None, 1.8, None),
            "fov": 79,
            "look_degrees": 25,
        },
        "STMDP6": {
            "step_size": 0.1,
            "rotation_degrees": 40,
            "visibility_distance": 1,
            "lighting_value": (None, None, 1.8, None),
            "fov": 89,
            "look_degrees": 20,
        },
        "STMDP7": {
            "step_size": 0.2,
            "rotation_degrees": 45,
            "visibility_distance": 1,
            "lighting_value": (None, None, None, -0.3),
            "fov": 99,
            "look_degrees": 15,
        },
        "STMDP8": {
            "step_size": 0.3,
            "rotation_degrees": 60,
            "visibility_distance": 1,
            "lighting_value": (None, None, None, -0.1),
            "fov": 109,
            "look_degrees": 10,
        },
        "STMDP9": {
            "step_size": 0.15,
            "rotation_degrees": 60,
            "visibility_distance": 1,
            "lighting_value": (1.9, None, None, None),
            "fov": 119,
            "look_degrees": 15,
        },
        "STMDP10": {
            "step_size": 0.25,
            "rotation_degrees": 30.0,
            "visibility_distance": 1,
            "lighting_value": (None, None, None, 0.4),
            "fov": 89,
            "look_degrees": 35,
        },
        "STMDP11": {
            "step_size": 0.1,
            "rotation_degrees": 40,
            "visibility_distance": 1,
            "lighting_value": (1.4, None, None, None),
            "fov": 89,
            "look_degrees": 20,
        },
        "STMDP12": {
            "step_size": 0.35,
            "rotation_degrees": 45,
            "visibility_distance": 1,
            "lighting_value": (None, None, None, -0.1),
            "fov": 79,
            "look_degrees": 15,
        },
        "STMDP13": {
            "step_size": 0.3,
            "rotation_degrees": 90,
            "visibility_distance": 1,
            "lighting_value": None,
            "fov": 99,
            "look_degrees": 15,
        },
        "STMDP14": {
            "step_size": 0.15,
            "rotation_degrees": 60,
            "visibility_distance": 1,
            "lighting_value": None,
            "fov": 69,
            "look_degrees": 30,
        },
        "STMDP15": {
            "step_size": 0.15,
            "rotation_degrees": 10,
            "visibility_distance": 1,
            "lighting_value": (None, None, 2.0, None),
            "fov": 79,
            "look_degrees": 30,
        },
        "STMDP16": {
            "step_size": 0.2,
            "rotation_degrees": 25,
            "visibility_distance": 1,
            "lighting_value": (1.7, None, None, None),
            "fov": 59,
            "look_degrees": 45,
        },
        "STMDP17": {
            "step_size": 0.35,
            "rotation_degrees": 25,
            "visibility_distance": 1,
            "lighting_value": (None, 2.4, None, None),
            "fov": 59,
            "look_degrees": 35,
        },
        "STMDP18": {
            "step_size": 0.3,
            "rotation_degrees": 15,
            "visibility_distance": 1,
            "lighting_value": (None, 1.7, None, None),
            "fov": 69,
            "look_degrees": 35,
        },
        "STMDP19": {
            "step_size": 0.15,
            "rotation_degrees": 15,
            "visibility_distance": 1,
            "lighting_value": (None, None, 0.8, None),
            "fov": 79,
            "look_degrees": 25,
        },
        "STMDP20": {
            "step_size": 0.25,
            "rotation_degrees": 40,
            "visibility_distance": 1,
            "lighting_value": (None, None, 2.4, None),
            "fov": 89,
            "look_degrees": 25,
        },
        "STMDP21": {
            "step_size": 0.25,
            "rotation_degrees": 30,
            "visibility_distance": 1,
            "lighting_value": (1.41, None, None, None),
            "fov": 89,
            "look_degrees": 20,
        },
        "STMDP22": {
            "step_size": 0.3,
            "rotation_degrees": 45,
            "visibility_distance": 1,
            "lighting_value": (None, None, None, -0.15),
            "fov": 79,
            "look_degrees": 15,
        },
        "STMDP23": {
            "step_size": 0.25,
            "rotation_degrees": 15,
            "visibility_distance": 1,
            "lighting_value": (None, None, 2.0, None),
            "fov": 79,
            "look_degrees": 30,
        },
        "STMDP24": {
            "step_size": 0.15,
            "rotation_degrees": 15,
            "visibility_distance": 1,
            "lighting_value": (None, None, 2.0, None),
            "fov": 79,
            "look_degrees": 15,
        },
        "STMDP25": {
            "step_size": 0.15,
            "rotation_degrees": 15,
            "visibility_distance": 1,
            "lighting_value": (None, None, 2.0, None),
            "fov": 79,
            "look_degrees": 30,
        },
        "STMDP26": {
            "step_size": 0.2,
            "rotation_degrees": 30,
            "visibility_distance": 1,
            "lighting_value": (1.75, None, None, None),
            "fov": 59,
            "look_degrees": 45,
        },
        "STMDP27": {
            "step_size": 0.2,
            "rotation_degrees": 30,
            "visibility_distance": 1,
            "lighting_value": (None, None, 1.24, None),
            "fov": 89,
            "look_degrees": 30,
        },
        "STMDP28": {
            "step_size": 0.3,
            "rotation_degrees": 30,
            "visibility_distance": 1,
            "lighting_value": (None, 1.72, None, None),
            "fov": 69,
            "look_degrees": 30,
        },
        "STMDP29": {
            "step_size": 0.15,
            "rotation_degrees": 15,
            "visibility_distance": 1,
            "lighting_value": (None, None, 0.85, None),
            "fov": 79,
            "look_degrees": 25,
        },
        "STMDP30": {
            "step_size": 0.2,
            "rotation_degrees": 30,
            "visibility_distance": 1,
            "lighting_value": (None, None, 2.42, None),
            "fov": 89,
            "look_degrees": 25,
        },
        "UTMDP1": {
            "step_size": 0.18,
            "rotation_degrees": 29.0,
            "visibility_distance": 1,
            "lighting_value": (0.9, 0.01, 0.01, -0.2),
            "fov": 48,
            "look_degrees": 29.0,
        },
        "UTMDP2": {
            "step_size": 0.16,
            "rotation_degrees": 19.0,
            "visibility_distance": 1,
            "lighting_value": (2.5, 4.5, 4.0, 0.2),
            "fov": 57,
            "look_degrees": 31.0,
        },
        "UTMDP3": {
            "step_size": 0.18,
            "rotation_degrees": 21.0,
            "visibility_distance": 1,
            "lighting_value": (0.7, 4.5, 0.01, 0.3),
            "fov": 58,
            "look_degrees": 18.0,
        },
        "UTMDP4": {
            "step_size": 0.22,
            "rotation_degrees": 31.0,
            "visibility_distance": 1,
            "lighting_value": (2.5, 0.01, 4.0, -0.3),
            "fov": 62,
            "look_degrees": 17.0,
        },
        "UTMDP5": {
            "step_size": 0.22,
            "rotation_degrees": 29.0,
            "visibility_distance": 1,
            "lighting_value": (0.8, 0.01, 4.0, 0.4),
            "fov": 76,
            "look_degrees": 14.0,
        },
        "UTMDP6": {
            "step_size": 0.18,
            "rotation_degrees": 29.0,
            "visibility_distance": 1,
            "lighting_value": (2.5, 4.5, 0.01, -0.3),
            "fov": 84,
            "look_degrees": 16.0,
        },
        "UTMDP7": {
            "step_size": 0.19,
            "rotation_degrees": 44.0,
            "visibility_distance": 1,
            "lighting_value": (1., 1., 1., 0.),
            "fov": 92,
            "look_degrees": 34.0,
        },
        "UTMDP8": {
            "step_size": 0.22,
            "rotation_degrees": 28.0,
            "visibility_distance": 1,
            "lighting_value": (2., 2., 2., 0.2),
            "fov": 92,
            "look_degrees": 36.0,
        },
        "UTMDP9": {
            "step_size": 0.18,
            "rotation_degrees": 21.0,
            "visibility_distance": 1,
            "lighting_value": (3., 2., 1., 0.),
            "fov": 102,
            "look_degrees": 41.0,
        },
        "UTMDP10": {
            "step_size": 0.29,
            "rotation_degrees": 31.0,
            "visibility_distance": 1,
            "lighting_value": (2., 1., 3., 0.),
            "fov": 112,
            "look_degrees": 39.0,
        },
        
        
        "TESTMDP": {
            "step_size": 0.15,
            "rotation_degrees": 30.0,
            "visibility_distance": 1,
            "lighting_value": (0.2, 0.9, 1.5, -0.4),
            "fov": 112,
            "look_degrees": 30.0,
        },
    }
    '''
    '''

    import os
    test_mdp = os.environ.get('MDP', False)
    if test_mdp:
        print(test_mdp)
        STEP_SIZE =                 base_mdp_configs[test_mdp]["step_size"]
        ROTATION_DEGREE =          base_mdp_configs[test_mdp]["rotation_degrees"]
        LIGHTING_VALUE =            base_mdp_configs[test_mdp]["lighting_value"]
        HORIZONTAL_FIELD_OF_VIEW =  base_mdp_configs[test_mdp]["fov"]
        LOOK_DEGREE =              base_mdp_configs[test_mdp]["look_degrees"]
    
    ADVANCE_SCENE_ROLLOUT_PERIOD: Optional[int] = None
    SENSORS: Optional[Sequence[Sensor]] = None

    # STEP_SIZE = 0.25
    # ROTATION_DEGREES = 30.0
    # DISTANCE_TO_GOAL = 0.2
    DISTANCE_TO_GOAL = 1.5
    STOCHASTIC = True

    CAMERA_WIDTH = 400
    CAMERA_HEIGHT = 300
    SCREEN_SIZE = 224
    MAX_STEPS = 500

    def __init__(self):
        self.REWARD_CONFIG = {
            "step_penalty": -0.01,
            "goal_success_reward": 10.0,
            "failed_stop_reward": 0.0,
            "reached_max_steps_reward": 0.0,
            "shaping_weight": 1.0,
        }
