## MoCo: Momentum Contrast for Unsupervised Visual Representation Learning

### Create Environment
```
conda create -n moco python=3.7
conda activate moco
```

### Installation 

1. Install PyTorch

    Install pytorch for cuda version. Refer to the link below for installation instructions.

    https://pytorch.org/get-started/locally/

2. Install Requirements

    ```
    $ pip install -r requirements.txt
    ```

### Unsupervised Training
This implementation only supports **multi-gpu**, **DistributedDataParallel** training.; single-gpu or DataParallel training is not supported.

To do unsupervised pre-training of a ResNet-50 model on ImageNet in an 8-gpu machine, run:
```
python main_moco.py \
  -a resnet50 \
  --lr 0.03 \
  --batch-size 256 \
  --dist-url 'tcp://localhost:10000' --multiprocessing-distributed --world-size 1 --rank 0 \
  --epochs 50 \
  --pklroot {dataset_path} \
  --difficulty {save_dir} \
```
--pklroot : It is the path of the location of the data to be used for training. For experiment, '.pkl' data format were used.
--difficulty : It indicates the name of the folder to store the checkpoint. Automatically create a new folder with the name 'difficulty' in the 'output' folder.


***Note***: for 4-gpu training, we recommend following the `--lr 0.015 --batch-size 128` with 4 gpus. We got similar results using this setting.


### Dataset
- AI2-THOR : Sample Dataset is 'datasets/ObjNav12mdps_uint8_16shot.pkl'
- CARLA : Sample Dataset is 'datasets/episode_easy.pkl'

### Train
- AI-2THOR
  ```
  bash run_ai2thor.sh
  ```
- CARLA
  ```
  bash run_carla.sh
  ```