from dsl.value import Value, IntValue, ListValue, NULLVALUE
from dsl.types import FunctionType
import params

class OutputOutOfRangeError(Exception):
    pass

class NullInputError(Exception):
    pass

#def in_range(val):
#    if isinstance(val, IntValue):
#        val = ListValue([val.val])
#    for x in val.val:
#        if x < params.integer_min or x > params.integer_max:
#            return False
#    return True

def in_range(val_list):
    val = val_list[0]
    if isinstance(val, IntValue):
        if val.val < params.integer_min:
            val_list[0] = IntValue(params.integer_min)
            val = val_list[0]
        if val.val > params.integer_max:
            val_list[0] = IntValue(params.integer_max)
            val = val_list[0]
        if val.val < params.integer_min or val.val > params.integer_max:
            return False
    else:
        for i in range(len(val.val)):
            if val.val[i] < params.integer_min: val.val[i] = params.integer_min
            if val.val[i] > params.integer_max: val.val[i] = params.integer_max
            if val.val[i] < params.integer_min or val.val[i] > params.integer_max:
                return False
    return True

class Function(Value):
    def __init__(self, name, f, input_type, output_type):
        super(Function, self).__init__(f, FunctionType(input_type, output_type))
        self.name = name

    def __call__(self, *args):
        for i, arg in enumerate(args):
            if arg == NULLVALUE:
                output_val = NULLVALUE
                return output_val
#                raise NullInputError('{}({})'.format(self.name, args))
        raw_args = [x.val for x in args]
        output_raw = self.val(*raw_args)
        output_val = Value.construct(output_raw, self.output_type)
        tmp_list = [output_val]
        if output_val != NULLVALUE and not in_range(tmp_list):
            raise OutputOutOfRangeError('{}({})'.format(self.name, args))
        output_val = tmp_list[0]
        return output_val

    @property
    def input_type(self):
        return self.type.input_type

    @property
    def output_type(self):
        return self.type.output_type

    def __eq__(self, other):
        if not isinstance(other, Function):
            return False
        return self.name == other.name

    def __hash__(self):
        return hash(self.name)

    def __repr__(self):
        return str(self)

    def __str__(self):
        return self.name
