import argparse
import time

def get_arg_parser(title):
	parser = argparse.ArgumentParser(description=title)
	parser.add_argument('--cpu', action='store_true', default=False)
	parser.add_argument('--eval', action='store_true')
	parser.add_argument('--seq_only', action='store_true', default=False)
	parser.add_argument('--repeat_only', action='store_true', default=False)
	parser.add_argument('--no_branch', action='store_true', default=False)
	parser.add_argument('--baseline', action='store_true', default=False)
	parser.add_argument('--dataset_name', type=str, default='Karel', choices=['Karel'])
	parser.add_argument('--eval_mode', type=str, default='fwd', choices=['fwd', 'search', 'random'])
	parser.add_argument('--model_type', type=str, default='karel', choices=['karel'])
	parser.add_argument('--model_dir', type=str, default='../checkpoints/original')
	parser.add_argument('--train_dataset', type=str, default='../datasets/Karel/train.json')
	parser.add_argument('--val_dataset', type=str, default='../datasets/Karel/val.json')
	parser.add_argument('--test_dataset', type=str, default='../datasets/Karel/test.json')
	parser.add_argument('--vocab', type=str, default='../datasets/Karel/new_vocab.vocab')
	parser.add_argument('--prog_format', type=str, default='P', choices=['P', 'T'])
	parser.add_argument('--eval_max_size', type=int, default=2500)
	parser.add_argument('--max_prog_len', type=int, default=75)
	parser.add_argument('--load_model', type=str, default=None)
	parser.add_argument('--grid_size', type=int, default=18)
	parser.add_argument('--io_feature_size', type=int, default=16)
	parser.add_argument('--seed', type=int, default=100)

	parser.add_argument('--prediction_output', type=str, default='../prediction_output.txt')

	parser.add_argument('--hidden_size', type=int, default=256)	# 512
	parser.add_argument('--prog_embedding_size', type=int, default=256)	# 512
	parser.add_argument('--io_embedding_size', type=int, default=512)
	parser.add_argument('--io_count', type=int, default=5)
	parser.add_argument('--beam_size', type=int, default=64)
	parser.add_argument('--search_depth', type=int, default=80)
	parser.add_argument('--sample_bias', type=float, default=1e-4)
	parser.add_argument('--param_init', type=float, default=0.1)
	parser.add_argument('--num_RNN_layers', type=int, default=1)

	parser.add_argument('--keep_last_n', type=int, default=None)
	parser.add_argument('--eval_every_n', type=int, default=2500) # 100000
	parser.add_argument('--log_interval', type=int, default=2500) # 100000
	parser.add_argument('--log_name', type=str, default='../logs/original.csv')

	parser.add_argument('--optimizer', type=str, default='adam', choices=['adam', 'sgd', 'rmsprop'])
	parser.add_argument('--lr', type=float, default=1e-4)	# 5e-4
	parser.add_argument('--lr_decay_steps', type=int, default=None)
	parser.add_argument('--lr_decay_rate', type=float, default=None)
	parser.add_argument('--gradient_clip', type=float, default=5.0)
	parser.add_argument('--num_epochs', type=int, default=10)
	parser.add_argument('--batch_size', type=int, default=128)	# 16
	parser.add_argument('--dropout_rate', type=float, default=0.1)

	parser.add_argument('--compatibility-mode', action='store_true', help='If passed, allows the code to load old models')

	parser.add_argument('--local_rank', type=int)

	return parser
