import numpy as np
import argparse
import sys
import os
import re
import json
import pandas as pd

class Logger(object):
	def __init__(self, args):
		self.log_interval = args.log_interval
		self.log_name = args.log_name
		self.best_val_acc = 0
		self.best_val_loss = -1
		self.best_val_exact_acc = 0
		self.records = []

	def write_summary(self, summary):
		print("[%(model_type)s] global-step: %(global_step)d, train-loss: %(train_loss).3f, val-loss: %(val_loss).3f, " % summary)
		print("train-exact-acc: %(train_exact_acc).3f, val-exact-acc: %(val_exact_acc).3f" % summary)
		print("train-generalization-acc: %(train_generalization_acc).3f, val-generalization-acc: %(val_generalization_acc).3f" % summary)		
		self.records.append(summary)
		df = pd.DataFrame(self.records)
		df.to_csv(self.log_name, index=False)
		self.best_val_acc = max(self.best_val_acc, summary['val_generalization_acc'])
		self.best_val_exact_acc = max(self.best_val_exact_acc, summary['val_exact_acc'])
		if self.best_val_loss == -1 or summary['val_loss'] < self.best_val_loss:
			self.best_val_loss = summary['val_loss']