#!/bin/bash

train_script="./cmds/train_cmd.py"


result_folder="exps/supervised_use_grammar"

#if [ ! -d ${result_folder} ]; then
#  echo "create ${result_folder}"
#  mkdir ${result_folder}
#fi
#if [ ! -d "${result_folder}/Weights" ]; then
#  echo "create ${result_folder}/Weights"
#  mkdir "${result_folder}/Weights"
#fi

echo "run training script"
OMP_NUM_THREADS=1 \
python -m torch.distributed.launch \
    --nproc_per_node=4  \
    --use_env \
    --master_port=$RANDOM \
    ${train_script} \
    --kernel_size 3 \
    --conv_stack "64,64,64" \
    --fc_stack "512" \
    --tgt_embedding_size 256 \
    --lstm_hidden_size 256 \
    --nb_lstm_layers 2 \
    \
    --signal supervised \
    --nb_ios 5 \
    --nb_epochs 10000 \
    --optim_alg Adam \
    --batch_size 32 \
    --learning_rate 1e-4 \
    \
    --train_file ../trained_models/E1/GPS-202110020018/train.json \
    --val_file ../trained_models/E1/GPS-202110020018/val.json \
    --vocab datasets/karel/1m_6ex_karel/new_vocab.vocab \
    --result_folder $result_folder \
    \
    --use_grammar \
    \
    --use_cuda
