#!/bin/bash

script="./cmds/eval_cmd.py"


result_folder="exps/supervised_use_grammar"

echo "run eval script"
OMP_NUM_THREADS=1 \
python -m torch.distributed.launch \
    --nproc_per_node=4  \
    --use_env \
    --master_port=$RANDOM \
    ${script} \
    --kernel_size 3 \
    --conv_stack "64,64,64" \
    --fc_stack "512" \
    --tgt_embedding_size 256 \
    --lstm_hidden_size 256 \
    --nb_lstm_layers 2 \
    \
    --dataset ../trained_models/display_link/GPS-202109081719/val.json \
    --vocabulary datasets/karel/1m_6ex_karel/new_vocab.vocab \
    \
    --use_grammar \
    --random_test
