# Prompt templates for code problem synthesis and test input generation

# Prompt for generating new code problems
NEW_CODE_PROBLEM_SYNTHESIS_PROMPT = '''
I will provide you with a programming problem along with its solution. Your task is to create a new, transformed programming problem based on the original one.  

You need to complete the following steps:  
1. Analyze and understand the original problem and its solution. Identify the reasoning steps (e.g., Step 1, Step 2, Step 3) and summarize the knowledge points tested in the original problem.  
2. Design a new problem that is similar to the original one and can be solved using the same knowledge points. If you reference any conditions or descriptions from the original problem, rewrite them clearly and avoid phrases like "as in the original problem."  
   - Provide two example test cases to demonstrate the new problem.  
   - Ensure that the complexity of the new problem is well-designed by specifying appropriate input constraints.
3. Provide a solution to the new problem that meets the following requirements:  
   - Include a step-by-step solution plan (enclosed within `<plan>` and `<end_of_plan>`).  
   - Provide a Python implementation of the solution (enclosed within `<code>` and `<end_of_code>`).  

Your output should follow this format:  

```
## Part 1: Original Problem and Solution Analysis  
Step 1: [Describe the first step of reasoning]  
Step 2: [Describe the second step of reasoning]  
...  
Knowledge Points: [Summarize the knowledge points tested, separated by commas if there are multiple]  

## Part 2: New Problem  
Problem Description:
[Describe the new problem clearly in natural language. Ensure it doesn't directly copy from the original problem description. Avoid phrases like "as in the original problem".]  

Input Format:
[Specify the input format]

Output Format:  
[Specify the output format]

## Part 3: Example Test Cases  
Input: [Input for test case 1]  
Output: [Expected output for test case 1]  

Input: [Input for test case 2]  
Output: [Expected output for test case 2]  

Given Problem:
{question}

Given Solution:
{solution}
'''

# Test input generation prompt for standard IO-based problems
TEST_INPUT_GENERATION_PROMPT_FOR_STANDARD_IO_BASED_PROBLEMS = '''\
I will provide you with a programming problem description, and your task is to **generate standardized test input samples using the CYaRon library**.

You need to complete the following steps:

1. **Parse the constraints** on the input from the problem description, such as the range of input data, specific input constraints, etc.
2. **Write a function `generate_test_input`** using the `CYaRon` library to randomly generate test inputs based on a specified problem size. The function should validate that the parameters fall within the specified constraints. If any parameter is out of range, the function should return `None`. If the parameters are valid, generate a random test input and return an input string (`input_string`). 
3. **Write a function `validate_test_input`** to verify whether the generated test input satisfies the requirements specified in the problem description. This includes checking the input data type and constraints parsed in step 1, such as range and other conditions. The function should take `input_string` as input and return a boolean (`True`/`False`). 

Your output format should follow the structure below:

---

## Part 1: Parse Input Constraints
<Specify the input constraints as described in the problem>

## Part 2: Code for Test Input Generation
```python
import cyaron as cy

def generate_test_input(<param1>, <param2>, ...):
    # Check if parameters meet constraints
    if not (<condition1>) or not (<condition2>): 
        return None
    
    # Generate input using CYaRon
    input_data = [
      ...
    ]
    
    return "\n".join(map(str, input_data))
```

## Part 3: Code to Validate Test Input
```python
def validate_test_input(input_string):
    # Validation logic
    return <boolean>
```

Given Problem:
{question}
'''

# Test input generation prompt for function-based problems
TEST_INPUT_GENERATION_PROMPT_FOR_FUNCTION_BASED_PROBLEM = '''\
I will provide you with a programming problem description, and your task is to **generate standardized test input samples using the CYaRon library**.

You need to complete the following steps:

1. **Parse the constraints** on the input from the problem description, such as the range of input data, specific input constraints, etc. **Understand the starter code** to determine the expected function signature and input parameters. For example, if the starter code includes `def solve(n: int, arr: List[int])`, then the inputs should be mapped accordingly.
2. **Write a function `generate_test_input`** using the `CYaRon` library to randomly generate test inputs based on a specified problem size in the format of a Python dictionary and returns it as a JSON string** (e.g., `'{{"n": 5, "arr": [1, 2, 3, 4, 5]}}'`). If the parameters are invalid (e.g., out of the allowed constraints), return `None`.
3. **Write a function `validate_test_input`** to verify whether the generated test input satisfies the requirements specified in the problem description. This includes checking the input data type and constraints parsed in step 1, such as range and other conditions. The function should take the input JSON string as input, parse it, and check for correctness. Return `True` if valid, otherwise `False`.

Your output format should follow the structure below:

---

## Part 1: Parse Input Constraints
<Specify the input constraints as described in the problem>

## Part 2: Code for Test Input Generation
```python
import cyaron as cy
import json

def generate_test_input(<param1>, <param2>, ...):
    # Check if parameters meet constraints
    if not (<condition1>) or not (<condition2>): 
        return None
    
    # Generate input using CYaRon
    <generate values for each argument>

    input_dict = {{
        "arg1": value1,
        "arg2": value2,
        ...
    }}

    return json.dumps(input_dict)
```

## Part 3: Code to Validate Test Input
```python
def validate_test_input(input_string):
    # Validation logic
    try:
        input_data = json.loads(input_string)
    except:
        return False
    # Perform validation
    if not (<validation_condition1>):
        return False
    if not (<validation_condition2>):
        return False
    return True
```

Given Problem:
{question}

Starter Code:
```python
{starter_code}
```
'''

# Ablation study: prompt for directly generating test input
DIRECTLY_GENERATE_TEST_INPUT_PROMPT = '''
I will provide you with a programming problem description, and your task is to generate test inputs for the problem. 

You need to generate **50 test inputs** that effectively **verify the correctness of the core logic** and **assess the time complexity** of the solution. 
Ensure that your test cases cover a **diverse range of problem scales**, including **edge cases, small inputs, and large inputs** that push the problem's constraints.

Your output should follow this JSON format:  
```json
{{
  "test_inputs": [
    {{
      "idx": 0,
      "input_string": <simple test input 0>,
    }},
    ...
  ],
}}
```

Given Problem:
{question}
'''

# Ablation study: prompt for directly generating test input-output pairs
DIRECTLY_GENERATE_TEST_INPUT_OUTPUT_PAIRS_PROMPT = '''
I will provide you with a programming problem description, and your task is to generate test inputs and outputs for the problem. 

You need to generate **50 test inputs and outputs pair** that effectively **verify the correctness of the core logic** and **assess the time complexity** of the solution. 
Ensure that your test cases cover a **diverse range of problem scales**, including **edge cases, small inputs, and large inputs** that push the problem's constraints.

Your output should follow this JSON format:  
```json
{{
  "test_inputs": [
    {{
      "idx": 0,
      "input_string": <test input 0>,
      "output_string": <test output 0>
    }},
    ...
  ],
}}
```

Given Problem:
{question}
'''

