# TODO: add import and comment

def concurrent_call(inputs, query_model="gpt-4", max_threads=10, sampling_params=None, max_retry=2000):
    texts, preds = [], []
    with concurrent.futures.ProcessPoolExecutor(max_workers=max_threads) as executor:
        futures = [executor.submit(call_gpt, input, query_model, sampling_params, max_retry) for input in inputs]
        for i, future in tqdm(
            enumerate(concurrent.futures.as_completed(futures)),
            total=len(futures),
            desc=f"calling {query_model}",
        ):
            prompt, ans = future.result()
            texts.append(prompt)
            preds.append(ans)
    return texts, preds

def call_gpt(input, query_model, sampling_params, max_retry=100):
    pass

