import os
from os import listdir
from os.path import isfile, join
import warnings
import argparse

parser = argparse.ArgumentParser(description='')
parser.add_argument('--path', default="facades_pix2pix", type=str)
parser.add_argument('--ngf', default="24", type=str)

args = parser.parse_args()

for epoch in range(0, 201, 5):
    folder_path = "./results/" + args.path + "/test_"+str(epoch)+"/images/"
    patterns = ['_fake_B', '_real_B', '_fake_A', '_real_A']
    folders = [os.path.join(folder_path, pattern) for pattern in patterns]
    os.system("python test.py --dataroot ./datasets/horse2zebra --name " + args.path + " --model cycle_gan --ngf="+args.ngf+" --epoch "+str(epoch))
    for folder in folders:
        if not os.path.exists(folder):
            os.makedirs(folder)
    name_list = os.listdir(folder_path)
    for item in name_list:
        if 'real_B' in item:
            name = item.split("_")[0] + ".png"
            os.system("mv " + folder_path + item +" "+ folder_path + "/_real_B/" + item)
        if 'fake_B' in item:
            name = item.split("_")[0] + ".png"
            os.system("mv " + folder_path + item +" "+ folder_path + "/_fake_B/" + item)
        if 'fake_A' in item:
            name = item.split("_")[0] + ".png"
            os.system("mv " + folder_path + item +" "+ folder_path + "/_fake_A/" + item)
        if 'real_A' in item:
            name = item.split("_")[0] + ".png"
            os.system("mv " + folder_path + item +" "+ folder_path + "/_real_A/" + item)

for epoch in range(0, 201, 5):
    print ("-------------------- Epoch Index ", epoch, " ---------------------")
    folder_path = "./results/" + args.path + "/test_" + str(epoch) + "/images/"
    os.system("python -m pytorch_fid " + folder_path + "/_real_B/" + "  " + folder_path + "/_fake_B/")
    os.system("python -m pytorch_fid " + folder_path + "/_real_A/" + "  " + folder_path + "/_fake_A/")





