#  Region-aware Knowledge Distillation

This is the code for ICLR2022 submission *Not All Regions are Worthy to be Distilled: Region-aware Knowledge Distillation Towards Efficient Image-to-Image Translation* . This code is based on the official released codes of CycleGAN and Pix2Pix. 

**Installation (step-1).**  Firstly,follow the base codes from https://github.com/junyanz/pytorch-CycleGAN-and-pix2pix/tree/master/options (the official released codes of CycleGAN and Pix2Pix, note that **we are not the authors of them** ) for installing the based packages such as Pytorch and torchvision. After installing all the packages and downloading the datasets (horse2zebra), please verify the rightness of your codes with the following command

```
python train.py --dataroot ./datasets/horses2zebras --name test --model CycleGAN --ngf=64
```

**Installation (step-2).** 

pytorch_fid is a usefull module for computing the FID socres. Please install it by running

```
pip install pytorch_fid
```

------------

**Training Teachers**. The training scripts of teacher models.

```
# train cyclegan teacher on horse2zebra and zebra2horse
python train.py --dataroot ./datasets/horses2zebras --name h2z_teacher --model CycleGAN --ngf=64
```

After training the teacher models, please choose the checkpoint with the lowest FID as the teacher model for knowledge distillation. You can use the following code for evaluating the FID for different epochs. 

```
python get_fid_horse2zebra.py --name=h2z_teacher --ngf=64
```

You can choose the best checkpoints (lowest FID) based on their output logs. 

**Training Students**.  The training scripts of student models. 

```
# region-aware knowledge distillation on CycleGANs and Horse2Zebra
python distill.py --dataroot ./datasets/horse2zebra/ --name h2z_cyclegan_student --model cycle_gan --ngf=32 --teacher_exp_name=h2z_teacher   --kd_contrastive=1 --choice_of_feature 13 --lpip 5
```

After training the student models, you can evaluate them with the following epoch. Note that the reported FID is the lowest FID of all the checkpoints. Besides, we take the average FID from eight experiments as the reported result. Please run more experiments for stable results.

```
python get_fid_horse2zebra.py --name=h2z_cyclegan_student --ngf=24
```

Besides, after evaluation, you  also find the generated images of students and teachers in the result folder.

----------------------------

Finally, if you find any problems in running these codes, you may find the answers in the official released codes from CycleGAN and Pix2Pix (https://github.com/junyanz/pytorch-CycleGAN-and-pix2pix/tree/master/options). If the problems can not be addressed, you can also raise them during rebuttal. 

We thanks again for your detailed reviews ! 