import torch.distributed as dist

from typing import Optional

from .Logger import Logger

logger = None


def get_logger(
    outputs_dir: Optional[str] = None,
    root_path: Optional[str] = None,
) -> Logger:
    """ Get the logger.

    Args:
        outputs_dir (Optional[str], optional): The outputs directory. Defaults to None.
        root_path (Optional[str], optional): The root path. Defaults to None.

    Returns:
        Logger: The logger.
    """

    global logger

    # Get the local rank.
    local_rank = dist.get_rank() if dist.is_initialized() else 0

    if logger is None:
        logger = Logger(
            local_rank=local_rank,
            outputs_dir=outputs_dir,
            root_path=root_path,
        )

    return logger
