import os
import shutil

from typing import Dict


def build_replications(
    path_dict: Dict[str, str],
    outputs_dir: str,
) -> None:
    """ Build replications.

    Args:
        path_dict (Dict[str, str]): The path dictionary.
        outputs_dir (str): The replication directory.
    """

    for name, path in path_dict.items():
        if path is None or not os.path.exists(path):
            continue

        _, file_extension = os.path.splitext(p=path.split(sep='/')[-1])
        replication_path = os.path.join(
            outputs_dir,
            (name + file_extension),
        )

        shutil.copy(
            src=path,
            dst=replication_path,
        )
