import numpy as np

from typing import Any


def handle_non_serializable_object(object: Any) -> Any:
    """ Handle non-serializable object.

    Args:
        object (Any): The object to handle.

    Returns:
        Any: The handled object.
    """

    if isinstance(object, np.float32) or \
            isinstance(object, np.float64):
        return float(object)
    elif isinstance(object, np.int32) or \
            isinstance(object, np.int64):
        return int(object)
    elif isinstance(object, set):
        return list(object)
    else:
        return str(object)
