from ..get.path import get_path
from ...logging import get_logger


def set_seed(seed: int = 48763) -> None:
    """ Set the seed.

    Args:
        seed (int, optional): The seed. Defaults to 48763.
    """

    try:
        logger = get_logger()
        source = f'{get_path(source_file=__file__)}.{set_seed.__name__}'
    except:
        pass

    try:
        import numpy as np

        np.random.seed(seed=seed)
    except ImportError:
        message = 'Failed to import numpy.'

        try:
            logger.log(
                message=message,
                level='error',
                source=source,
            )
        except:
            print(message)

            pass

        pass

    try:
        from pandas.core.common import random_state

        random_state(state=seed)
    except ImportError:
        message = 'Failed to import pandas.'

        try:
            logger.log(
                message=message,
                level='error',
                source=source,
            )
        except:
            print(message)

            pass

        pass

    try:
        import random

        random.seed(a=seed)
    except ImportError:
        message = 'Failed to import random.'

        try:
            logger.log(
                message=message,
                level='error',
                source=source,
            )
        except:
            print(message)

            pass

        pass

    try:
        import torch

        torch.manual_seed(seed=seed)
        torch.backends.cudnn.benchmark = False
        torch.backends.cudnn.deterministic = True
        torch.cuda.manual_seed(seed=seed)
        torch.cuda.manual_seed_all(seed=seed)
    except ImportError:
        message = 'Failed to import torch.'

        try:
            logger.log(
                message=message,
                level='error',
                source=source,
            )
        except:
            print(message)

            pass

        pass
