import os

from typing import Dict


def build_dirs(
    path_dict: Dict[str, str],
    exist_ok: bool = True,
) -> None:
    """ Create directories.

    Args:
        path_dict (Dict[str, str]): The dictionary of paths.
        exist_ok (bool, optional): If True, do not raise an exception if the directory already exists. Defaults to True.
    """

    for key, value in path_dict.items():
        os.makedirs(
            name=value,
            exist_ok=exist_ok,
        )
