import os

from pathlib import Path


def get_path(
    source_file: str,
    return_dir: bool = False,
) -> str:
    """ Get the path or the directory of the source file.

    Args:
        source_file (str): The source file.
        return_dir (bool, optional): Only return the directory. Defaults to False.

    Returns:
        str: The path or the directory of the source file.
    """

    dir = os.path.dirname(p=os.path.abspath(path=source_file))
    name = Path(source_file).stem

    return dir if return_dir else os.path.join(
        dir,
        name,
    )
