import json

from typing import (
    Any,
    Dict,
)


def get_json_config(config_path: str) -> Dict[str, Any]:
    """ Get the configuration from the JSON file.

    Args:
        config_path (str): The path to the JSON file.

    Returns:
        Dict[str, Any]: The configuration.
    """

    config = None

    with open(
            file=config_path,
            mode='r',
    ) as f:
        config = json.load(fp=f)

    return config
