import torch
import torch.distributed as dist


def get_min_local_rank() -> int:
    """ Get the minimum local rank of all processes.

    Returns:
        int: The minimum local rank of all processes.
    """

    if not dist.is_initialized():
        return -1

    local_rank = dist.get_rank()
    world_size = dist.get_world_size()

    local_rank = torch.tensor(
        data=[local_rank],
        device=torch.device(device=local_rank),
    )
    all_local_ranks = [
        torch.zeros_like(input=local_rank) \
            for _ in range(world_size)
    ]

    dist.all_gather(
        tensor_list=all_local_ranks,
        tensor=local_rank,
    )

    return min(local_rank.item() for local_rank in all_local_ranks)
