#!/bin/bash

# If any command fails, the script will exit immediately.
set -e

# Set the environment variables.
export HF_ALLOW_CODE_EVAL=1
export LD_LIBRARY_PATH="$CONDA_PREFIX/lib:$LD_LIBRARY_PATH"
export TOKENIZERS_PARALLELISM=true

## Reference: https://docs.nvidia.com/deeplearning/nccl/user-guide/docs/env.html#nccl-debug
# export NCCL_DEBUG=INFO

## Reference: https://docs.nvidia.com/deeplearning/nccl/user-guide/docs/env.html#nccl-p2p-level
export NCCL_P2P_LEVEL=LOC

## Reference: https://docs.nvidia.com/deeplearning/nccl/user-guide/docs/env.html#nccl-p2p-disable
# export NCCL_P2P_DISABLE=1

## Reference: https://docs.nvidia.com/deeplearning/nccl/user-guide/docs/env.html#nccl-shm-disable
# export NCCL_SHM_DISABLE=1

# GPU_IDS=""
GPU_IDS="0"

# VERSION=""
VERSION="20250623_fd412182"

# If you want to run more than one job on the same machine, you need to specify different MASTER_PORT for each job.
MASTER_PORT=48763

# The molos model config file path.
# =====

MODEL_CONFIG_PATH="configs/testings/${VERSION}/model_config.json"

# =====

# The DeepSpeed config file path.
DS_CONFIG_PATH="configs/testings/common/ds_config.json"

# The LoRA config file path.
# LORA_CONFIG_PATH="configs/testings/${VERSION}/lora_config.json"

echo "GCC Version: $(gcc --version | head -n 1)"
echo "G++ Version: $(g++ --version | head -n 1)"
echo "CUDA Toolkit Version: $(nvcc --version | grep release | sed 's/.*release //; s/,//')"

for config_index in $(seq 0 2)
do
    # The config file path.
    CONFIG_PATH="configs/testings/${VERSION}/${config_index}_task_config.yaml"

    # Test the model with LoRA.
    # deepspeed \
    #     --include=localhost:${GPU_IDS} \
    #     --master_port ${MASTER_PORT} \
    #     ds_main.py \
    #     -c ${CONFIG_PATH} \
    #     -mc ${MODEL_CONFIG_PATH} \
    #     -dsc ${DS_CONFIG_PATH} \
    #     -lc ${LORA_CONFIG_PATH} \
    #     -m test \
    #     -mt molos \
    #     -is_oriup \
    #     -cei -1

    # Test the model without LoRA.
    deepspeed \
        --include=localhost:${GPU_IDS} \
        --master_port ${MASTER_PORT} \
        ds_main.py \
        -c ${CONFIG_PATH} \
        -mc ${MODEL_CONFIG_PATH} \
        -dsc ${DS_CONFIG_PATH} \
        -m test \
        -mt molos \
        -is_oriup \
        -cei -1
done
