/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.spanish;

import java.util.regex.Pattern;

public class SpanishUnknownWordSignatures {
    private static final Pattern pMasculine = Pattern.compile("os?$");
    private static final Pattern pFeminine = Pattern.compile("as?$");
    private static final Pattern pConditionalSuffix = Pattern.compile("[aei]r\u00eda(?:s|mos|is|n)?$");
    private static final Pattern pImperfectErIrSuffix = Pattern.compile("[^r]\u00eda(?:s|mos|is|n)?$");
    private static final Pattern pImperfect = Pattern.compile("(?:aba(?:[sn]|is)?|\u00e1bamos|[^r]\u00eda(?:s|mos|is|n)?)$");
    private static final Pattern pInfinitive = Pattern.compile("[aei]r$");
    private static final Pattern pAdverb = Pattern.compile("mente$");
    private static final Pattern pVerbFirstPersonPlural = Pattern.compile("(?<!\u00falt|m\u00e1x|m\u00edn|\u00e1n|pr\u00f3x|\u00eds|c\u00e9nt|[np]\u00f3n|pr\u00e9st|g\u00edt|\u00ednt|p\u00e1r|^extr|^supr|^tr?|^[Rr]?|gr)[eia]mos$");
    private static final Pattern pGerund = Pattern.compile("(?i)((?<!^([bmn]|bl|com|contrab|cu|[fh]ern))a|(?<!^(asci|ati|atu|compr|condesci|conti|desati|desci|desenti|disti|divid|enci|enti|estup|exti|fi|hi|malenti|pret|refer|rever|sobreenti|subti|ti|transci|trasci|trem))e)ndo$");

    private SpanishUnknownWordSignatures() {
    }

    public static boolean hasMasculineSuffix(String s) {
        return pMasculine.matcher(s).find();
    }

    public static boolean hasFeminineSuffix(String s) {
        return pFeminine.matcher(s).find();
    }

    public static boolean hasConditionalSuffix(String s) {
        return pConditionalSuffix.matcher(s).find();
    }

    public static boolean hasImperfectErIrSuffix(String s) {
        return pImperfectErIrSuffix.matcher(s).find();
    }

    public static boolean hasImperfectSuffix(String s) {
        return pImperfect.matcher(s).find();
    }

    public static boolean hasInfinitiveSuffix(String s) {
        return pInfinitive.matcher(s).find();
    }

    public static boolean hasAdverbSuffix(String s) {
        return pAdverb.matcher(s).find();
    }

    public static boolean hasVerbFirstPersonPluralSuffix(String s) {
        return pVerbFirstPersonPlural.matcher(s).find();
    }

    public static boolean hasGerundSuffix(String s) {
        return pGerund.matcher(s).find();
    }

    public static String conditionalSuffix(String s) {
        return SpanishUnknownWordSignatures.hasConditionalSuffix(s) ? "-cond" : "";
    }

    public static String imperfectSuffix(String s) {
        return SpanishUnknownWordSignatures.hasImperfectSuffix(s) ? "-imp" : "";
    }

    public static String infinitiveSuffix(String s) {
        return SpanishUnknownWordSignatures.hasInfinitiveSuffix(s) ? "-inf" : "";
    }

    public static String adverbSuffix(String s) {
        return SpanishUnknownWordSignatures.hasAdverbSuffix(s) ? "-adv" : "";
    }
}

