#!/bin/bash
# Set job name
#SBATCH --job-name=FairTTE
# Specify the number of nodes and processors and gpus per nodes
#SBATCH --nodes=1 --ntasks-per-node=1 --gpus-per-node=1
# Specify the maximum amount of physical memory required
#SBATCH --mem=80GB
#SBATCH --cpus-per-task=8

# Load modules:
module load python/3.12
module load cuda/11.8.0

source activate fairbench

## Do your things
cd $SLURM_SUBMIT_DIR # Goto the directory where the job is submitted'
if [ "$pretrained" = "False" ]; then
# No pretrained
echo "Pretrained: False"
python script/get_representation.py --surv_model ${surv_model} --fair_model ${fair_model} --dataset ${dataset} --sensitive_attribute ${sensitive_attribute} --metric ${metric} --gpu 'osc' --hparams_seed ${hparams_seed} --seed ${seed} --shift ${shift} --group_shift ${group_shift} > 'logs/log_repr_'${surv_model}'_'${fair_model}'_'${dataset}'_'${sensitive_attribute}'_'${metric}'_'${pretrained}'_'${shift}'_'${group_shift}'_'${hparams_seed}'_'${seed}'.txt'
else
# Pretrained
echo "Pretrained: True"
python script/get_representation.py --surv_model ${surv_model} --fair_model ${fair_model} --dataset ${dataset} --sensitive_attribute ${sensitive_attribute} --metric ${metric} --gpu 'osc' --hparams_seed ${hparams_seed} --seed ${seed} --shift ${shift} --group_shift ${group_shift} --pretrained > 'logs/log_repr_'${surv_model}'_'${fair_model}'_'${dataset}'_'${sensitive_attribute}'_'${metric}'_'${pretrained}'_'${shift}'_'${group_shift}'_'${hparams_seed}'_'${seed}'.txt'
fi