(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     99581,       2007]
NotebookOptionsPosition[     97099,       1955]
NotebookOutlinePosition[     97822,       1979]
CellTagsIndexPosition[     97742,       1974]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Create", " ", "Point", " ", "Processes"}], "*)"}]], "Input",
 CellChangeTimes->{{3.925377224002739*^9, 
  3.9253772362631493`*^9}},ExpressionUUID->"fd3121a6-675f-45e6-a1e1-\
993e8a8c7c31"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Poisson", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SeedRandom", "[", "123456", "]"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "0"}], ",", 
     RowBox[{"i", "<", "1000"}], ",", 
     RowBox[{"i", "++"}], ",", 
     RowBox[{"Export", "[", 
      RowBox[{
       RowBox[{"StringJoin", "[", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", 
         "\"\<Data/Poisson_Processes/\>\"", ",", 
         RowBox[{"ToString", "[", "i", "]"}], ",", "\"\<.csv\>\""}], "]"}], 
       ",", 
       RowBox[{
        RowBox[{"RandomPointConfiguration", "[", 
         RowBox[{
          RowBox[{"PoissonPointProcess", "[", 
           RowBox[{"200", ",", "2"}], "]"}], ",", 
          RowBox[{"Rectangle", "[", "]"}]}], "]"}], "[", "\"\<Points\>\"", 
        "]"}]}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.924246396260693*^9, 3.924246409895274*^9}, {
   3.924246548041318*^9, 3.9242465483847227`*^9}, {3.924246848725259*^9, 
   3.924246874759021*^9}, {3.9242472139978447`*^9, 3.9242472191006203`*^9}, {
   3.924247360730891*^9, 3.924247368726264*^9}, {3.9242474390138693`*^9, 
   3.9242474411308727`*^9}, {3.92424750736528*^9, 3.9242475370865297`*^9}, {
   3.9242475729596167`*^9, 3.924247647091216*^9}, {3.9242477077184343`*^9, 
   3.924247712771181*^9}, 3.924247784879332*^9, {3.9246915795947933`*^9, 
   3.9246916003293257`*^9}, 3.924691661277721*^9, {3.92469238863372*^9, 
   3.9246923970047483`*^9}, 3.925296999662734*^9, {3.925377241758667*^9, 
   3.9253772491643553`*^9}, {3.925377450353228*^9, 3.9253774760823517`*^9}, {
   3.925377553143252*^9, 3.925377553689434*^9}, 3.9253776044539747`*^9, {
   3.9253776368347178`*^9, 3.925377647057019*^9}, 3.925377848217196*^9, {
   3.925377922967661*^9, 3.925377938206471*^9}},
 CellTags->"Export_templates",
 CellLabel->"In[1]:=",ExpressionUUID->"112311e4-8863-4c1b-9f98-d97a6027cffa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["RandomGeneratorState",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            GridBox[{{
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"ExtendedCA\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"State hash: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["7458285971915078912", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            GridBox[{{
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"ExtendedCA\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"State hash: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["7458285971915078912", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  RandomGeneratorState[{
   "ExtendedCA", {80, 4, 0}}, {{
    RawArray["UnsignedInteger64",{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
       0, 0, 0, 0, 0}], 0, 20, 20}, {CompressedData["
1:eJw9lUuOHEUQhi3Egq3BF+AAI0VExnPJciQWyIgDGDG2vDGSxxLi9nzZlUXP
qNWdXRWP/1U///n3+4/fvXnz5vUH3t5/+OeXr18//Pv7W7788eX186cvL389
f/n28unla/rH3/Z13/P26+fXb88/8SHXChNfYipLo9zW41x1uUy5x3R1uXqf
672WR2gtWzJSUo/zWNP7YuPCXr5K/XFekT0SI6vGqyNjHuc2S6VCI5bZsh7z
5x/39SI9qh7pvYYW+jjOVWWSs8tVa40+v+P4KVNGhzOLXUXpc7WlorZmyHIt
r5K5bohwz5wOl/Cl2XIqeVl5tluv1Cxe8qi0t4qaoYNoiTHgqcRMCXxdspKF
e67Nnkx0qe5xwW4GUK4bivl1llvRNinVfVpL89NMBP9iYnFhvfc0D6BiYhO+
nPPQZtsMDyl+BcCrkFbzuaOBTYLNuw5MAq8NyM207N1zVdpzLmiEeKDtvcx1
3pYDcJIFTkjBz6jcu7emHNwVCx6an3wSlLM2F2LMFhcPshhDReC6GCv9Aomu
wUuDNuJj1D0r6IZMVyy05J2TduklzQRsJG24B43lNakl/Botyts2cXZPKoY4
kDVQDOI2vW6YEUdI9J1wNvGLZ05H4DNlMSeOsAuKZFUk5wMKzVgUfShyV8AJ
taEDctFrHiYHAHZQWATyOH5y4J0NWy4gAkQ/1DRIIvRsdjU3QSBXX2WUQC/N
UIWwb91hxQkDu2xzH0cctypcAcMwc7dGy0ECMpKXooCNBF+vkRI1OEQxFSSj
U70QMh3NIRaKQXGgR53VLCqAHhKVtj5HFCgC+3GkGBd98+VwgCDd6B3YB9rS
/egR0QqcQSRuVG6p4x28R12yx5x78NXVmsnBbz3IwMBSt1xYgj8SLJVSTsBc
hbR2TGzZgy9jTxww0Bz6HE8MjR7t1ott9hPLJMIA2jjKJlUy4IAdQZr8ymNn
fO25tlIhGbcTkgeORG385ki1yUubC9encfga7AEX3IV/jsJ0J8wKjDJB/tkh
lPgqhNU7DlHa9FEAnXKztqAUP66ok2ELQRjXdxTCXsTNEdnOMJwkOFYKceia
G461ZUwN2aKxjnWXotBO7EJSO2Lq3IHFlTgQuCOjyf84PaoYZwdToWTE536m
2kAXHo15uK4nzx6JqX0/MHAuIGRpP7+9fjAM1BtABUg7URKGYgWnbQmKq/yv
MqxiaG1lPYR/4Qc4yJr9yETcAr1zHm1cj7AHejYNYHMHNKOpsPBW+E78W2U4
F/MQR2hQBx3eD43eub0fg+zdRNxtCT4DIIWAVAg0AuXiFIpo23iK3NX9FLp7
Qw4hZo/HSkNt/wcZVWkB
     "], 4, 0}}, RawArray["UnsignedInteger64",{7458285971915078912, 0}]],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{
  3.925377481202124*^9, 3.925377556710725*^9, {3.925377608447579*^9, 
   3.925377648058776*^9}, 3.925377721724628*^9, 3.925377852103744*^9, 
   3.92537794336228*^9, 3.925378014436565*^9, 3.925379634771411*^9},
 CellTags->"Export_templates",
 CellLabel->"Out[1]=",ExpressionUUID->"d3655f70-8db5-483f-a4a7-7180ab70168b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Matern", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SeedRandom", "[", "123456", "]"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "0"}], ",", 
     RowBox[{"i", "<", "1000"}], ",", 
     RowBox[{"i", "++"}], ",", 
     RowBox[{"Export", "[", 
      RowBox[{
       RowBox[{"StringJoin", "[", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", 
         "\"\<Data/Matern_Processes/\>\"", ",", 
         RowBox[{"ToString", "[", "i", "]"}], ",", "\"\<.csv\>\""}], "]"}], 
       ",", 
       RowBox[{
        RowBox[{"RandomPointConfiguration", "[", 
         RowBox[{
          RowBox[{"MaternPointProcess", "[", 
           RowBox[{"40", ",", "5", ",", ".1", ",", "2"}], "]"}], ",", 
          RowBox[{"Rectangle", "[", "]"}]}], "]"}], "[", "\"\<Points\>\"", 
        "]"}]}], "]"}]}], "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.9242477612460546`*^9, 3.924247805171818*^9}, 
   3.92469166880291*^9, {3.924692403826419*^9, 3.924692414176683*^9}, 
   3.925297183862866*^9, {3.925377253397481*^9, 3.925377262522355*^9}, {
   3.925377987256012*^9, 3.9253779933115683`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"49c315ad-a190-451f-af20-5aaf21f6bff2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["RandomGeneratorState",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            GridBox[{{
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"ExtendedCA\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"State hash: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["3705168857552671598", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            GridBox[{{
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"ExtendedCA\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"State hash: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["3705168857552671598", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  RandomGeneratorState[{
   "ExtendedCA", {80, 4, 0}}, {{
    RawArray["UnsignedInteger64",{8494763455436917097, 11520058250447820368, 
      2778105, 10060760135493343193, 12232237395773803257, 
      3237709555013890505, 3772994331801707645, 17743779050956246351, 
      17575771004815128281, 4476865127809684418, 11759809734055975910, 
      4486630240242233678, 14141857419871384994, 10567803796543608503, 
      3907857206933685403, 11737292554459662116, 7887785090867688223, 
      10264906492165758572, 14912191701991421522, 6647836059610751799}], 0, 
     20, 20}, {CompressedData["
1:eJw9lUuOHEUQhi3Egq3BF+AAI0VExnPJciQWyIgDGDG2vDGSxxLi9nzZlUXP
qNWdXRWP/1U///n3+4/fvXnz5vUH3t5/+OeXr18//Pv7W7788eX186cvL389
f/n28unla/rH3/Z13/P26+fXb88/8SHXChNfYipLo9zW41x1uUy5x3R1uXqf
672WR2gtWzJSUo/zWNP7YuPCXr5K/XFekT0SI6vGqyNjHuc2S6VCI5bZsh7z
5x/39SI9qh7pvYYW+jjOVWWSs8tVa40+v+P4KVNGhzOLXUXpc7WlorZmyHIt
r5K5bohwz5wOl/Cl2XIqeVl5tluv1Cxe8qi0t4qaoYNoiTHgqcRMCXxdspKF
e67Nnkx0qe5xwW4GUK4bivl1llvRNinVfVpL89NMBP9iYnFhvfc0D6BiYhO+
nPPQZtsMDyl+BcCrkFbzuaOBTYLNuw5MAq8NyM207N1zVdpzLmiEeKDtvcx1
3pYDcJIFTkjBz6jcu7emHNwVCx6an3wSlLM2F2LMFhcPshhDReC6GCv9Aomu
wUuDNuJj1D0r6IZMVyy05J2TduklzQRsJG24B43lNakl/Botyts2cXZPKoY4
kDVQDOI2vW6YEUdI9J1wNvGLZ05H4DNlMSeOsAuKZFUk5wMKzVgUfShyV8AJ
taEDctFrHiYHAHZQWATyOH5y4J0NWy4gAkQ/1DRIIvRsdjU3QSBXX2WUQC/N
UIWwb91hxQkDu2xzH0cctypcAcMwc7dGy0ECMpKXooCNBF+vkRI1OEQxFSSj
U70QMh3NIRaKQXGgR53VLCqAHhKVtj5HFCgC+3GkGBd98+VwgCDd6B3YB9rS
/egR0QqcQSRuVG6p4x28R12yx5x78NXVmsnBbz3IwMBSt1xYgj8SLJVSTsBc
hbR2TGzZgy9jTxww0Bz6HE8MjR7t1ott9hPLJMIA2jjKJlUy4IAdQZr8ymNn
fO25tlIhGbcTkgeORG385ki1yUubC9encfga7AEX3IV/jsJ0J8wKjDJB/tkh
lPgqhNU7DlHa9FEAnXKztqAUP66ok2ELQRjXdxTCXsTNEdnOMJwkOFYKceia
G461ZUwN2aKxjnWXotBO7EJSO2Lq3IHFlTgQuCOjyf84PaoYZwdToWTE536m
2kAXHo15uK4nzx6JqX0/MHAuIGRpP7+9fjAM1BtABUg7URKGYgWnbQmKq/yv
MqxiaG1lPYR/4Qc4yJr9yETcAr1zHm1cj7AHejYNYHMHNKOpsPBW+E78W2U4
F/MQR2hQBx3eD43eub0fg+zdRNxtCT4DIIWAVAg0AuXiFIpo23iK3NX9FLp7
Qw4hZo/HSkNt/wcZVWkB
     "], 4, 0}}, RawArray["UnsignedInteger64",{3705168857552671598, 0}]],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.925378024486305*^9, 3.9253796435367317`*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"084c8148-4d2f-4131-b879-80a15b7ef2d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Strauss", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SeedRandom", "[", "123456", "]"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "0"}], ",", 
     RowBox[{"i", "<", "1000"}], ",", 
     RowBox[{"i", "++"}], ",", 
     RowBox[{"Export", "[", 
      RowBox[{
       RowBox[{"StringJoin", "[", 
        RowBox[{
         RowBox[{"NotebookDirectory", "[", "]"}], ",", 
         "\"\<Data/Strauss_Processes/\>\"", ",", 
         RowBox[{"ToString", "[", "i", "]"}], ",", "\"\<.csv\>\""}], "]"}], 
       ",", 
       RowBox[{
        RowBox[{"RandomPointConfiguration", "[", 
         RowBox[{
          RowBox[{"StraussPointProcess", "[", 
           RowBox[{"1200", ",", "0.5", ",", "0.075", ",", "2"}], "]"}], ",", 
          RowBox[{"Rectangle", "[", "]"}]}], "]"}], "[", "\"\<Points\>\"", 
        "]"}]}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.924247823841153*^9, 3.924247828795586*^9}, 
   3.92469167221371*^9, {3.924692420948269*^9, 3.9246924212963953`*^9}, {
   3.925377265498568*^9, 3.925377270938151*^9}, {3.925377999346332*^9, 
   3.925378006523615*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"a24064a6-0790-49c4-8ea0-b87784afd546"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["RandomGeneratorState",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            GridBox[{{
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"ExtendedCA\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"State hash: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["6493375364386697354", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            GridBox[{{
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"ExtendedCA\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"State hash: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["6493375364386697354", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  RandomGeneratorState[{
   "ExtendedCA", {80, 4, 0}}, {{
    RawArray["UnsignedInteger64",{804305204474, 7661650665450382759, 
      7145316194813167790, 7942254589485858783, 18316553647146668669, 
      17288810412101850989, 7843565231606820621, 6282159023620333239, 
      1152096351856615488, 15427696571507254728, 7877908021100056523, 
      895347058136000194, 12643042642358477808, 16895097400701409787, 
      12026508145455292342, 4367773628334906358, 12549957152019889180, 
      6372740445203967565, 6718946123453925906, 14623424392592067960}], 0, 20,
      20}, {CompressedData["
1:eJw9lUuOHEUQhi3Egq3BF+AAI0VExnPJciQWyIgDGDG2vDGSxxLi9nzZlUXP
qNWdXRWP/1U///n3+4/fvXnz5vUH3t5/+OeXr18//Pv7W7788eX186cvL389
f/n28unla/rH3/Z13/P26+fXb88/8SHXChNfYipLo9zW41x1uUy5x3R1uXqf
672WR2gtWzJSUo/zWNP7YuPCXr5K/XFekT0SI6vGqyNjHuc2S6VCI5bZsh7z
5x/39SI9qh7pvYYW+jjOVWWSs8tVa40+v+P4KVNGhzOLXUXpc7WlorZmyHIt
r5K5bohwz5wOl/Cl2XIqeVl5tluv1Cxe8qi0t4qaoYNoiTHgqcRMCXxdspKF
e67Nnkx0qe5xwW4GUK4bivl1llvRNinVfVpL89NMBP9iYnFhvfc0D6BiYhO+
nPPQZtsMDyl+BcCrkFbzuaOBTYLNuw5MAq8NyM207N1zVdpzLmiEeKDtvcx1
3pYDcJIFTkjBz6jcu7emHNwVCx6an3wSlLM2F2LMFhcPshhDReC6GCv9Aomu
wUuDNuJj1D0r6IZMVyy05J2TduklzQRsJG24B43lNakl/Botyts2cXZPKoY4
kDVQDOI2vW6YEUdI9J1wNvGLZ05H4DNlMSeOsAuKZFUk5wMKzVgUfShyV8AJ
taEDctFrHiYHAHZQWATyOH5y4J0NWy4gAkQ/1DRIIvRsdjU3QSBXX2WUQC/N
UIWwb91hxQkDu2xzH0cctypcAcMwc7dGy0ECMpKXooCNBF+vkRI1OEQxFSSj
U70QMh3NIRaKQXGgR53VLCqAHhKVtj5HFCgC+3GkGBd98+VwgCDd6B3YB9rS
/egR0QqcQSRuVG6p4x28R12yx5x78NXVmsnBbz3IwMBSt1xYgj8SLJVSTsBc
hbR2TGzZgy9jTxww0Bz6HE8MjR7t1ott9hPLJMIA2jjKJlUy4IAdQZr8ymNn
fO25tlIhGbcTkgeORG385ki1yUubC9encfga7AEX3IV/jsJ0J8wKjDJB/tkh
lPgqhNU7DlHa9FEAnXKztqAUP66ok2ELQRjXdxTCXsTNEdnOMJwkOFYKceia
G461ZUwN2aKxjnWXotBO7EJSO2Lq3IHFlTgQuCOjyf84PaoYZwdToWTE536m
2kAXHo15uK4nzx6JqX0/MHAuIGRpP7+9fjAM1BtABUg7URKGYgWnbQmKq/yv
MqxiaG1lPYR/4Qc4yJr9yETcAr1zHm1cj7AHejYNYHMHNKOpsPBW+E78W2U4
F/MQR2hQBx3eD43eub0fg+zdRNxtCT4DIIWAVAg0AuXiFIpo23iK3NX9FLp7
Qw4hZo/HSkNt/wcZVWkB
     "], 4, 0}}, RawArray["UnsignedInteger64",{6493375364386697354, 0}]],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.9253780358711157`*^9, 3.925379655033852*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"418afab2-d4e2-495a-a7ad-590cca684d29"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Plot", " ", "Point", " ", "Processes"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.9253772810586348`*^9, 
  3.925377285013028*^9}},ExpressionUUID->"7e0ec231-f01f-42b1-97db-\
047ad4fdd162"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", "Poisson", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SeedRandom", "[", "123456", "]"}], "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"RandomPointConfiguration", "[", 
      RowBox[{
       RowBox[{"PoissonPointProcess", "[", 
        RowBox[{"200", ",", "2"}], "]"}], ",", 
       RowBox[{"Rectangle", "[", "]"}]}], "]"}], "[", "\"\<Points\>\"", "]"}],
     "]"}]}]}]], "Input",
 CellChangeTimes->{{3.9246850301227217`*^9, 3.924685036585496*^9}, {
  3.924691639167886*^9, 3.924691654003078*^9}, {3.924692498124301*^9, 
  3.924692498492605*^9}, {3.925377290525457*^9, 3.925377290724161*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"ed79abde-f76d-463b-bc91-ee43dd4944c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["RandomGeneratorState",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            GridBox[{{
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"ExtendedCA\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"State hash: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["1103665407378623894", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            GridBox[{{
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"ExtendedCA\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"State hash: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["1103665407378623894", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  RandomGeneratorState[{
   "ExtendedCA", {80, 4, 0}}, {{
    RawArray["UnsignedInteger64",{6175452063264936498, 281072547448903831, 
      11558722747842596363, 10741347827009777551, 15337748597644567674, 
      8169651309961501649, 12664339033024060127, 8662032680093527684, 
      7999665331125079757, 18134974756955119282, 15286280151662634179, 
      10327130439390319834, 9940224834182226553, 8614237222444271666, 
      11533825583491419747, 2856716637038731196, 1802578244822398371, 
      9374568309542783549, 2395474786708062323, 18053933287106452693}], 0, 20,
      20}, {CompressedData["
1:eJw9lUuOHEUQhi3Egq3BF+AAI0VExnPJciQWyIgDGDG2vDGSxxLi9nzZlUXP
qNWdXRWP/1U///n3+4/fvXnz5vUH3t5/+OeXr18//Pv7W7788eX186cvL389
f/n28unla/rH3/Z13/P26+fXb88/8SHXChNfYipLo9zW41x1uUy5x3R1uXqf
672WR2gtWzJSUo/zWNP7YuPCXr5K/XFekT0SI6vGqyNjHuc2S6VCI5bZsh7z
5x/39SI9qh7pvYYW+jjOVWWSs8tVa40+v+P4KVNGhzOLXUXpc7WlorZmyHIt
r5K5bohwz5wOl/Cl2XIqeVl5tluv1Cxe8qi0t4qaoYNoiTHgqcRMCXxdspKF
e67Nnkx0qe5xwW4GUK4bivl1llvRNinVfVpL89NMBP9iYnFhvfc0D6BiYhO+
nPPQZtsMDyl+BcCrkFbzuaOBTYLNuw5MAq8NyM207N1zVdpzLmiEeKDtvcx1
3pYDcJIFTkjBz6jcu7emHNwVCx6an3wSlLM2F2LMFhcPshhDReC6GCv9Aomu
wUuDNuJj1D0r6IZMVyy05J2TduklzQRsJG24B43lNakl/Botyts2cXZPKoY4
kDVQDOI2vW6YEUdI9J1wNvGLZ05H4DNlMSeOsAuKZFUk5wMKzVgUfShyV8AJ
taEDctFrHiYHAHZQWATyOH5y4J0NWy4gAkQ/1DRIIvRsdjU3QSBXX2WUQC/N
UIWwb91hxQkDu2xzH0cctypcAcMwc7dGy0ECMpKXooCNBF+vkRI1OEQxFSSj
U70QMh3NIRaKQXGgR53VLCqAHhKVtj5HFCgC+3GkGBd98+VwgCDd6B3YB9rS
/egR0QqcQSRuVG6p4x28R12yx5x78NXVmsnBbz3IwMBSt1xYgj8SLJVSTsBc
hbR2TGzZgy9jTxww0Bz6HE8MjR7t1ott9hPLJMIA2jjKJlUy4IAdQZr8ymNn
fO25tlIhGbcTkgeORG385ki1yUubC9encfga7AEX3IV/jsJ0J8wKjDJB/tkh
lPgqhNU7DlHa9FEAnXKztqAUP66ok2ELQRjXdxTCXsTNEdnOMJwkOFYKceia
G461ZUwN2aKxjnWXotBO7EJSO2Lq3IHFlTgQuCOjyf84PaoYZwdToWTE536m
2kAXHo15uK4nzx6JqX0/MHAuIGRpP7+9fjAM1BtABUg7URKGYgWnbQmKq/yv
MqxiaG1lPYR/4Qc4yJr9yETcAr1zHm1cj7AHejYNYHMHNKOpsPBW+E78W2U4
F/MQR2hQBx3eD43eub0fg+zdRNxtCT4DIIWAVAg0AuXiFIpo23iK3NX9FLp7
Qw4hZo/HSkNt/wcZVWkB
     "], 4, 0}}, RawArray["UnsignedInteger64",{1103665407378623894, 0}]],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.925378063901176*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"4131aec2-b44b-449c-9cbc-4ab67a249a57"],

Cell[BoxData[
 GraphicsBox[{{}, 
   InterpretationBox[{
     TagBox[
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        0.009166666666666668], AbsoluteThickness[2], PointBox[CompressedData["

1:eJwVlnk8FPj/x2eLsqWSVFgttdW6llk5Iy9Kqb6ShJBQEUk1oVKORo5sK0dS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         "]]},
       Annotation[#, "Charting`Private`Tag#1"]& ],
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{
          Annotation[{
            Directive[
             PointSize[0.009166666666666668], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Point[CompressedData["
1:eJwVlnk8FPj/x2eLsqWSVFgttdW6llk5Iy9Kqb6ShJBQEUk1oVKORo5sK0dS
Qykkd6UcixQNO87kmIxjxjGXwRxsarHSb35/fB6fx+ePz+fx+hzv5/Oz+dRF
R98lBAKhQdr+v7egrzVPezIItWZH9kYzAbx/j/GMeFIABUqrzbfRWpQ7e0Xt
6BlCzbqTiqeXcrBk1npj8HE+lB1X2TsbT+LR3efX9CkDCPnk4lK1UoJy6m2b
0XssNDIZZRYBTCjc51c71DbBU5UTaaA5DpeqEB+Hfjas3LZ+ll02BgGRQK8q
6sW+Ob9Db0VskBIIivNpEnifjN75d3E9ili08JxWCQKTlPec3cAFd8vFmzof
JCCOxY3dOdII8mm3tOZlAuQa+wf/+pqDQLfhQaNODnqbB9JajYRwiqwwHYtm
Qz5ge06RQAynrbMhskQOchWevh9SYsJq8+EIDPdgfkWEXEaWGMQ1Ba2z66pB
uHUouraoAoLHxa51b/goIdarM+Y4WCyyaxjfPoaJ6baW53slUFOpSm1w7Yd8
2M5ioRIDavrl1wLKP6H5iI/Ff8UM6Kqfdx3ym8SIrzffN7YEVtR7KV6jY0g4
5WYrkOZwXVEeyrraCZJ8BXmZ1Ws4JWoeq7QZwIjGB/UOWiWoIpxwcBEh8INl
m+P7UQwtX5Mf9XQUVTJn0t1LhDCNOWJ9mSVCcsCNStnwUnhr/WxynvMRpOy+
KN91dJDte1NszSowZbfikHPOO2jwqH0DxA+If8do3KE6jKnzXZMe1zuhMH/A
Izp5DGfcqgkOytL1K59/ue40iErb8pWbP4vhbWuqVSefh/DYgyNNtyZwZYKy
ItuTg4KE9QrrnAdgfD+SH+LGh9P1RUNn3VHEV1LDIjJFIG4I2xd7vA3d6x/I
X89kw9v82uTq7DwI99WeFT9iIsRGNOvhLkTnwWMe1tvYKC3bH9dn8BHyT8qU
OvqZcKQUaLNWCVBVVDg1HdoCzzRCogd1FCPH636olq2EapDqZdkhDqro3Qzx
Szpcrx1XE7xpB4Wuf+z0Kh5Kq5zzP+c0YL9gzipMgYaSlRHDh0r4yNrgyfsY
SEfcJYXh1i9sEJe5xb0aGgCNJXu9xpQPe8IQxU5+As0J3Gc5RBYyIlLyasl8
bJHjxkVQJDD8d1bFe+cwKPzFnawCJgySJ4/sn+Uh6/HQYaX0Z6D36RmuCxpF
p/UlT5FnDSIz5e7sWMqGjLUKbENG4d9Orc00+oCp8vQiHc4gNNnOH7eNf4TD
2ClOGLkd9tYJKqwG6XvXtP2VpTWIohCLRatpEeanVupSdk2A+GKm23lHLZoL
ZQI6zRoQuqarLiloGKYzG/s3+nVB43bGqqGeVsivLTbYxu5FX0xDzsw/3Si9
UWZ30HsApkQ9xTJGB6Z49rwhMwaqxK0XNr9shWudT4K7PwOkTcVeXfRx9NoV
6n5TlJ7jMaN3TjbS+d4Hm/sdmlHu4Jn9cZGF1W179Kc9hCCb6Z2gXnoBPbmv
8yEtYyipvKLIfMMAgS5uM0v8hC3UQ7/9UToBZso765krEiyoMIufL/bDKb++
OoE7AGJWoo63RJpn9sfFZ1Hl+JkmS2T+PYLOcvm0E8QOsGN+nbsXJYRSbcM+
9z8ZiDmBR98VRNiqNDt1s3AEI2/tFB6v48Pq8iWfo9UfEf941xHR9iFs2C8T
7aPGw/bYxVSWLRfJxdM9C4kMcIOCXULspPe+h3ngyPt2zDfJMKe7JzBjtdMk
Jm8I3Milm26OMxAfeyvZ9hwD9cu4V63VqSCvW/1J71smrO6U/PP2Rh7IXvoB
M27RoOxauVOrqBPXt4+ymC1sFKjWFOy7NIKA//2X1yIvkI4VLUwoLHh8ieFe
NO/C4qzQt19aHyUrjLMyRgUgUDbUL7bcQenaOq9/z4lhJ+8bkn6Xi4ILp5wL
vJjwudFJvXtUAt24vsnDqgNYTdl8/raTANp9pE/5WyZQOVxIMafzcbvHMemk
7SS6M1/8zvlRgto062zLfh4UOG25Xwpp0DCQ/fVuOwPJC4qa91N6MeVr6kY8
U4lyjb3eeunS3DWpk4/YNBhvnDm2InEU9eYJfleuPoWSk+WLjMFBEO6tzDnh
cB/CwW1aQ28lyHpKivQsew+CLzfpissHkDKoxWTtv+DBM0sa+IOJ1raf3l0/
NoKCD63Le2nN0K1u2vP9OBsLKz5VX9fuxYxeatmh3/uQvOgx81C/Dqb5/nvJ
Qjqszv118P2adITrPwvPqZeAIG4zGLyZC24FodKd0gOrsH8GvGhvkGBQrO9D
4oKQleYmWLYLWRqXGo7ShOj93ysNEyn3lUl0W48wFsg/nwvv/4WDvibxpfdB
TBQY7VWn1wxDsCsw1+qr1D97v7ee0ZtAvcvDq06K9QgItJ3I6uRh5A1kQ/qb
EbJ4J/DrVDdcv/9rwX4kBDPjodt6FTEcHux4//JBE7zjSdrqLs8RalOl8MiB
C5++iaOWyuMoTTLXuX9bhKqHzs3hjpPwrlyjtj06B97FtIuWWgMgRdonD/8n
AZOQvvTu3UmUbkgNnm2thPC2XoxJVzf4GmbnqnREmLnQcHpu2xisDt+zFB9s
xiw9mcH69jd29/m9i8sew0ikg4IJ6y2Sk+oMPy/WwbJnt+addDH4p+Jcr32V
gOSxztBivgFnoq2JL3fw4M4z3RMfJOVq7GZDbYYAZIlclK71n6hU7Cwzj+BC
oWAt9ZVuF3yyWbZ+B3pAWAi2Dtz6ByKTeL9E5QvQrC4X6WncBFN7ym8H9Mfh
P0Dvza5qg2K9xflhrTE0K508/4o2CpJh4ldifg0Szmw7of9XLzySSG0/cbiY
PRyVZ3KYj843jKaROjaM3bSID4kCKHiFG82d7EPImpDMnmomyFpzqfHMcZB1
1gpr3GswRb02eOauEITMIZtC3Y/QvD09FmE/jnKdufrtx7ukPk8OPjr1EApn
ZVaxTbvh0MQwqlWVcmgh4uy5x5cxO1Zv3Nb9ATaO+vMZ/4ghTn3YesNHhPqK
wEZuWhZK7ixJKfQaRFzekc2bD42Bai481LJbhAz/VtVqPzF0+aaE/bEsqKod
HtUM50PJKHD8l9VidF9ub2km8NDa3jWhYir1vZxybgrjJZRjTu32sesCuV04
bWN2Cwr+LhSSFgNZeyfpzal85B47hc2lQgTpjVZ0PhqXenMhvuP+GAirLdPZ
9WfQHpqfv8a4Hy6tb13q1HnodF24/Tm0Bo3hxV9Hlosgl6P5434vIeRu3gxT
3NGP7tWpAp8/ufhaNsPK9JCgqmdL00puI7JUUtUaK2gg6cZmX7GvgU3w8pve
KwegPKWX/bxvCMo+t16nb++D96oLBv/VSDA1kHj1dSAPp14ENzafE6A+03rT
D5vewCabavEbQ1oHLUHkDjM6PJaq3Z2+1A3TIw/Cp0Z68K6SrknbJ4GBO6d9
njOGOFWdx2fjRxFo1LhFnM+CBeH11WVMPu4la9+iUlmYXzqxM9pKgHdVdiNa
YaMQPumQiQ3gYGvpz+88D7BhqGmjYWcoQYYFjd2txoaaJdWidBcTpnWt6ryb
fVLf5tHuPKKhgOwrunCRjkYPq4kBGhdWs+7RPEk5Lsg9lbVh8HDv+9qClq0i
7HYtfqJuLq3PDrdSVX8m6usUTFyqpfs+qf7hvPkE7Dr23LD37MKKTTZpS45K
+Uf4Sc7B9DlqW/06bdpZIDb6FN7xacAG2/KOXE0pH047Ki/ZJf3/UiOSlH7o
wwg5LbCL/xqhrLMPEw9KeZ3ueIDygInFf2fEzooSlDRMNt1I6YbHfb2TQw50
LNZ0vTdRkeYjmy+pCR5E5yzDxMiwCuFTJ16dqvgEYnRbroyblANyFVr7Xkrf
1cPlJL8XXJgS9H9MsZ9A6W/UqCgpBzdcCNUR1osR7j8grOUI4K7jNdvkKEbB
D0aFlKsMWMi91F4IFUAx+IXVnw4iOHz7YlX6eAh2norO6dpS/2QFnbm//SVI
6wlz+8Ok3vvpjdnIsx4Mkb56HeOMIiC+0Gu9zDj+D0ehM4Q=
             "]]}, "Charting`Private`Tag#1"]}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0, 0.999496251915799}, {0, 0.9919272235555332}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.009166666666666668], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0, 0.999496251915799}, {0, 0.9919272235555332}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             PointSize[0.009166666666666668], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ListPlot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{
       Annotation[{
         Directive[
          PointSize[0.009166666666666668], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Point[CompressedData["
1:eJwVlnk8FPj/x2eLsqWSVFgttdW6llk5Iy9Kqb6ShJBQEUk1oVKORo5sK0dS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          "]]}, "Charting`Private`Tag#1"]}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{0, 0.999496251915799}, {0, 0.9919272235555332}}, 
        "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           PointSize[0.009166666666666668], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ListPlot, "GroupHighlight" -> False|>|>, 
     "DynamicHighlight"]], {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.999496251915799}, {0, 0.9919272235555332}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.925378064253458*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"6b44621e-642b-442f-b4d0-8583fc14b086"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Matern", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SeedRandom", "[", "123456", "]"}], "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"RandomPointConfiguration", "[", 
      RowBox[{
       RowBox[{"MaternPointProcess", "[", 
        RowBox[{"40", ",", "5", ",", ".1", ",", "2"}], "]"}], ",", 
       RowBox[{"Rectangle", "[", "]"}]}], "]"}], "[", "\"\<Points\>\"", "]"}],
     "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.9246850711917267`*^9, {3.925297100414832*^9, 3.925297103824544*^9}, {
   3.925377295399621*^9, 3.925377295527286*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"8800f88c-b66f-4222-837d-1d916b22c0de"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["RandomGeneratorState",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            GridBox[{{
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"ExtendedCA\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"State hash: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"-", "5718567516156189598"}], "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            GridBox[{{
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"ExtendedCA\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"State hash: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  RowBox[{"-", "5718567516156189598"}], "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  RandomGeneratorState[{
   "ExtendedCA", {80, 4, 0}}, {{
    RawArray["UnsignedInteger64",{32667559047942506, 11730306296505417448, 
      14261322259290903171, 17565666461715498369, 4980891222297404093, 
      4836836698313344532, 2293541016322417911, 15526526700394349284, 
      14766589169344954683, 16366889755688053149, 14108819997278059252, 
      6404671497011129735, 15742689619245938059, 15469562258050223799, 
      14884623574646079891, 1166111543793559814, 8175379877046187934, 
      6226784026117014848, 15757637517168175028, 1508125922131920862}], 0, 20,
      20}, {CompressedData["
1:eJw9lUuOHEUQhi3Egq3BF+AAI0VExnPJciQWyIgDGDG2vDGSxxLi9nzZlUXP
qNWdXRWP/1U///n3+4/fvXnz5vUH3t5/+OeXr18//Pv7W7788eX186cvL389
f/n28unla/rH3/Z13/P26+fXb88/8SHXChNfYipLo9zW41x1uUy5x3R1uXqf
672WR2gtWzJSUo/zWNP7YuPCXr5K/XFekT0SI6vGqyNjHuc2S6VCI5bZsh7z
5x/39SI9qh7pvYYW+jjOVWWSs8tVa40+v+P4KVNGhzOLXUXpc7WlorZmyHIt
r5K5bohwz5wOl/Cl2XIqeVl5tluv1Cxe8qi0t4qaoYNoiTHgqcRMCXxdspKF
e67Nnkx0qe5xwW4GUK4bivl1llvRNinVfVpL89NMBP9iYnFhvfc0D6BiYhO+
nPPQZtsMDyl+BcCrkFbzuaOBTYLNuw5MAq8NyM207N1zVdpzLmiEeKDtvcx1
3pYDcJIFTkjBz6jcu7emHNwVCx6an3wSlLM2F2LMFhcPshhDReC6GCv9Aomu
wUuDNuJj1D0r6IZMVyy05J2TduklzQRsJG24B43lNakl/Botyts2cXZPKoY4
kDVQDOI2vW6YEUdI9J1wNvGLZ05H4DNlMSeOsAuKZFUk5wMKzVgUfShyV8AJ
taEDctFrHiYHAHZQWATyOH5y4J0NWy4gAkQ/1DRIIvRsdjU3QSBXX2WUQC/N
UIWwb91hxQkDu2xzH0cctypcAcMwc7dGy0ECMpKXooCNBF+vkRI1OEQxFSSj
U70QMh3NIRaKQXGgR53VLCqAHhKVtj5HFCgC+3GkGBd98+VwgCDd6B3YB9rS
/egR0QqcQSRuVG6p4x28R12yx5x78NXVmsnBbz3IwMBSt1xYgj8SLJVSTsBc
hbR2TGzZgy9jTxww0Bz6HE8MjR7t1ott9hPLJMIA2jjKJlUy4IAdQZr8ymNn
fO25tlIhGbcTkgeORG385ki1yUubC9encfga7AEX3IV/jsJ0J8wKjDJB/tkh
lPgqhNU7DlHa9FEAnXKztqAUP66ok2ELQRjXdxTCXsTNEdnOMJwkOFYKceia
G461ZUwN2aKxjnWXotBO7EJSO2Lq3IHFlTgQuCOjyf84PaoYZwdToWTE536m
2kAXHo15uK4nzx6JqX0/MHAuIGRpP7+9fjAM1BtABUg7URKGYgWnbQmKq/yv
MqxiaG1lPYR/4Qc4yJr9yETcAr1zHm1cj7AHejYNYHMHNKOpsPBW+E78W2U4
F/MQR2hQBx3eD43eub0fg+zdRNxtCT4DIIWAVAg0AuXiFIpo23iK3NX9FLp7
Qw4hZo/HSkNt/wcZVWkB
     "], 4, 0}}, RawArray["UnsignedInteger64",{12728176557553362018, 0}]],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.9253780673380938`*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"3c0e8116-67d1-4930-850e-b60d9f9446cd"],

Cell[BoxData[
 GraphicsBox[{{}, 
   InterpretationBox[{
     TagBox[
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        0.009166666666666668], AbsoluteThickness[2], PointBox[CompressedData["

1:eJwVVmk4FAoXlmih6KssUYq49qWQCXlRkVuJCC1CuyhLlsoSleWKNnUpWtSt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         "]]},
       Annotation[#, "Charting`Private`Tag#1"]& ],
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{
          Annotation[{
            Directive[
             PointSize[0.009166666666666668], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Point[CompressedData["
1:eJwVVmk4FAoXlmih6KssUYq49qWQCXlRkVuJCC1CuyhLlsoSleWKNnUpWtSt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             "]]}, "Charting`Private`Tag#1"]}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0, 0.9996283974215662}, {0, 0.996644906010535}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.009166666666666668], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0, 0.9996283974215662}, {0, 0.996644906010535}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             PointSize[0.009166666666666668], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ListPlot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{
       Annotation[{
         Directive[
          PointSize[0.009166666666666668], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Point[CompressedData["
1:eJwVVmk4FAoXlmih6KssUYq49qWQCXlRkVuJCC1CuyhLlsoSleWKNnUpWtSt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          "]]}, "Charting`Private`Tag#1"]}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{0, 0.9996283974215662}, {0, 0.996644906010535}}, 
        "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           PointSize[0.009166666666666668], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ListPlot, "GroupHighlight" -> False|>|>, 
     "DynamicHighlight"]], {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.9996283974215662}, {0, 0.996644906010535}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.925378067400978*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"a1da9b42-6143-4e3e-b601-44dacf6262eb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "Strauss", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SeedRandom", "[", "123456", "]"}], "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"RandomPointConfiguration", "[", 
      RowBox[{
       RowBox[{"StraussPointProcess", "[", 
        RowBox[{"1200", ",", "0.5", ",", "0.075", ",", "2"}], "]"}], ",", 
       RowBox[{"Rectangle", "[", "]"}]}], "]"}], "[", "\"\<Points\>\"", "]"}],
     "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.9246850869196243`*^9, 3.924685182878677*^9}, {
   3.9246852206527443`*^9, 3.924685266801702*^9}, {3.9246853239182997`*^9, 
   3.924685344443706*^9}, {3.924685455222904*^9, 3.924685526154739*^9}, {
   3.92468556189923*^9, 3.924685607844124*^9}, {3.925297115375772*^9, 
   3.925297136151555*^9}, 3.925297201211083*^9, {3.9253773002444563`*^9, 
   3.9253773004450207`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"9248e21d-97fb-4397-a539-5e32bbc8cde2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["RandomGeneratorState",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            GridBox[{{
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"ExtendedCA\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"State hash: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["983839218927521408", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}], True -> GridBox[{{
            GridBox[{{
               RowBox[{
                 TagBox["\"Method: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"ExtendedCA\"", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"State hash: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["983839218927521408", "SummaryItem"]}]}}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{2}}, "Rows" -> {{Automatic}}},
              BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          BaselinePosition -> {1, 1}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  RandomGeneratorState[{
   "ExtendedCA", {80, 4, 0}}, {{
    RawArray["UnsignedInteger64",{929886042043964402, 8955735611489432823, 
      3262772352193222686, 3420327724357905786, 16958793532110553306, 
      1102608402784525125, 4234227815014729382, 15893865543628382461, 
      5313753672684485819, 5191577640392134160, 15997825657193754189, 115, 
      17241109806969494851, 2376617097210238342, 4107337825583590751, 
      44489125131978282, 6627478866038767870, 6195557518465249120, 
      5383854126485078990, 7355929945849686230}], 0, 20, 20}, {CompressedData["
1:eJw9lUuOHEUQhi3Egq3BF+AAI0VExnPJciQWyIgDGDG2vDGSxxLi9nzZlUXP
qNWdXRWP/1U///n3+4/fvXnz5vUH3t5/+OeXr18//Pv7W7788eX186cvL389
f/n28unla/rH3/Z13/P26+fXb88/8SHXChNfYipLo9zW41x1uUy5x3R1uXqf
672WR2gtWzJSUo/zWNP7YuPCXr5K/XFekT0SI6vGqyNjHuc2S6VCI5bZsh7z
5x/39SI9qh7pvYYW+jjOVWWSs8tVa40+v+P4KVNGhzOLXUXpc7WlorZmyHIt
r5K5bohwz5wOl/Cl2XIqeVl5tluv1Cxe8qi0t4qaoYNoiTHgqcRMCXxdspKF
e67Nnkx0qe5xwW4GUK4bivl1llvRNinVfVpL89NMBP9iYnFhvfc0D6BiYhO+
nPPQZtsMDyl+BcCrkFbzuaOBTYLNuw5MAq8NyM207N1zVdpzLmiEeKDtvcx1
3pYDcJIFTkjBz6jcu7emHNwVCx6an3wSlLM2F2LMFhcPshhDReC6GCv9Aomu
wUuDNuJj1D0r6IZMVyy05J2TduklzQRsJG24B43lNakl/Botyts2cXZPKoY4
kDVQDOI2vW6YEUdI9J1wNvGLZ05H4DNlMSeOsAuKZFUk5wMKzVgUfShyV8AJ
taEDctFrHiYHAHZQWATyOH5y4J0NWy4gAkQ/1DRIIvRsdjU3QSBXX2WUQC/N
UIWwb91hxQkDu2xzH0cctypcAcMwc7dGy0ECMpKXooCNBF+vkRI1OEQxFSSj
U70QMh3NIRaKQXGgR53VLCqAHhKVtj5HFCgC+3GkGBd98+VwgCDd6B3YB9rS
/egR0QqcQSRuVG6p4x28R12yx5x78NXVmsnBbz3IwMBSt1xYgj8SLJVSTsBc
hbR2TGzZgy9jTxww0Bz6HE8MjR7t1ott9hPLJMIA2jjKJlUy4IAdQZr8ymNn
fO25tlIhGbcTkgeORG385ki1yUubC9encfga7AEX3IV/jsJ0J8wKjDJB/tkh
lPgqhNU7DlHa9FEAnXKztqAUP66ok2ELQRjXdxTCXsTNEdnOMJwkOFYKceia
G461ZUwN2aKxjnWXotBO7EJSO2Lq3IHFlTgQuCOjyf84PaoYZwdToWTE536m
2kAXHo15uK4nzx6JqX0/MHAuIGRpP7+9fjAM1BtABUg7URKGYgWnbQmKq/yv
MqxiaG1lPYR/4Qc4yJr9yETcAr1zHm1cj7AHejYNYHMHNKOpsPBW+E78W2U4
F/MQR2hQBx3eD43eub0fg+zdRNxtCT4DIIWAVAg0AuXiFIpo23iK3NX9FLp7
Qw4hZo/HSkNt/wcZVWkB
     "], 4, 0}}, RawArray["UnsignedInteger64",{983839218927521408, 0}]],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellChangeTimes->{3.9253780703109627`*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"c12c1cf1-8588-405d-a6a4-d3578eb999b1"],

Cell[BoxData[
 GraphicsBox[{{}, 
   InterpretationBox[{
     TagBox[
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
        0.009166666666666668], AbsoluteThickness[2], PointBox[CompressedData["

1:eJwVlnlUDNoDx0foZXhalKK8V5aeUl6SyhPfIUrri9YXKVptCUXFYySEVKgk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         "]]},
       Annotation[#, "Charting`Private`Tag#1"]& ],
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{
          Annotation[{
            Directive[
             PointSize[0.009166666666666668], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Point[CompressedData["
1:eJwVlnlUDNoDx0foZXhalKK8V5aeUl6SyhPfIUrri9YXKVptCUXFYySEVKgk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             "]]}, "Charting`Private`Tag#1"]}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0, 0.9963488604288742}, {0, 0.9955544761549247}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.009166666666666668], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{0, 0.9963488604288742}, {0, 0.9955544761549247}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             PointSize[0.009166666666666668], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ListPlot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{
       Annotation[{
         Directive[
          PointSize[0.009166666666666668], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Point[CompressedData["
1:eJwVlnlUDNoDx0foZXhalKK8V5aeUl6SyhPfIUrri9YXKVptCUXFYySEVKgk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          "]]}, "Charting`Private`Tag#1"]}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{0, 0.9963488604288742}, {0, 0.9955544761549247}}, 
        "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           PointSize[0.009166666666666668], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ListPlot, "GroupHighlight" -> False|>|>, 
     "DynamicHighlight"]], {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.9963488604288742}, {0, 0.9955544761549247}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.925378070388918*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"a1a19a9f-9324-43a8-9308-3a232d59e2e6"]
}, Open  ]]
},
WindowSize->{1400.25, 766.5},
WindowMargins->{{233.25, Automatic}, {Automatic, 87.75}},
FrontEndVersion->"13.3 for Linux x86 (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"0213662c-059b-4316-9aab-e458cc162aef"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Export_templates"->{
  Cell[812, 29, 1956, 39, 90, "Input",ExpressionUUID->"112311e4-8863-4c1b-9f98-d97a6027cffa",
   CellTags->"Export_templates"],
  Cell[2771, 70, 4692, 92, 87, "Output",ExpressionUUID->"d3655f70-8db5-483f-a4a7-7180ab70168b",
   CellTags->"Export_templates"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Export_templates", 97460, 1966}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 229, 5, 29, "Input",ExpressionUUID->"fd3121a6-675f-45e6-a1e1-993e8a8c7c31"],
Cell[CellGroupData[{
Cell[812, 29, 1956, 39, 90, "Input",ExpressionUUID->"112311e4-8863-4c1b-9f98-d97a6027cffa",
 CellTags->"Export_templates"],
Cell[2771, 70, 4692, 92, 87, "Output",ExpressionUUID->"d3655f70-8db5-483f-a4a7-7180ab70168b",
 CellTags->"Export_templates"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7500, 167, 1286, 29, 110, "Input",ExpressionUUID->"49c315ad-a190-451f-af20-5aaf21f6bff2"],
Cell[8789, 198, 4897, 94, 87, "Output",ExpressionUUID->"084c8148-4d2f-4131-b879-80a15b7ef2d9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13723, 297, 1249, 29, 90, "Input",ExpressionUUID->"a24064a6-0790-49c4-8ea0-b87784afd546"],
Cell[14975, 328, 4898, 94, 87, "Output",ExpressionUUID->"418afab2-d4e2-495a-a7ad-590cca684d29"]
}, Open  ]],
Cell[19888, 425, 264, 6, 50, "Input",ExpressionUUID->"7e0ec231-f01f-42b1-97db-047ad4fdd162"],
Cell[CellGroupData[{
Cell[20177, 435, 779, 16, 90, "Input",ExpressionUUID->"ed79abde-f76d-463b-bc91-ee43dd4944c5"],
Cell[20959, 453, 4883, 94, 65, "Output",ExpressionUUID->"4131aec2-b44b-449c-9cbc-4ab67a249a57"],
Cell[25845, 549, 20053, 389, 242, "Output",ExpressionUUID->"6b44621e-642b-442f-b4d0-8583fc14b086"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45935, 943, 705, 16, 70, "Input",ExpressionUUID->"8800f88c-b66f-4222-837d-1d916b22c0de"],
Cell[46643, 961, 4955, 96, 65, "Output",ExpressionUUID->"3c0e8116-67d1-4930-850e-b60d9f9446cd"],
Cell[51601, 1059, 18871, 371, 242, "Output",ExpressionUUID->"a1da9b42-6143-4e3e-b601-44dacf6262eb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70509, 1435, 1010, 19, 110, "Input",ExpressionUUID->"9248e21d-97fb-4397-a539-5e32bbc8cde2"],
Cell[71522, 1456, 4853, 93, 65, "Output",ExpressionUUID->"c12c1cf1-8588-405d-a6a4-d3578eb999b1"],
Cell[76378, 1551, 20705, 401, 264, "Output",ExpressionUUID->"a1a19a9f-9324-43a8-9308-3a232d59e2e6"]
}, Open  ]]
}
]
*)

