####### The code is built based on I2SB (https://github.com/NVlabs/I2SB/tree/master)

from corruption.sisr import *



def build_corruption(opt, log, corrupt_type=None):
    if corrupt_type is None: corrupt_type = opt.corrupt

    if 'sisr' in corrupt_type:
        from .sisr import build_sisr
        k = Blurkernel(blur_type='gaussian',
                       kernel_size=31,
                       std=1.5).get_kernel()
        method = build_sisr(opt, log, k)
    else:
        raise RuntimeWarning(f"Unknown corruption: {corrupt_type}!")

    return method
