concept_thresh=0.93
predefined_concept=31
k_value=1000 # legacy hyper-param, does not matter for CTP
# Generate log directory path
LOG_DIR="./save_models/predefined_concept_${predefined_concept}_caption_flickr8k_concept_thresh_${concept_thresh}/blip2/"

# Create directories if they don't exist
mkdir -p "${LOG_DIR}"

LOG_FILE="${LOG_DIR}training_log_tune_cc_ct${concept_thresh}_pc${predefined_concept}_$(date +%Y%m%d_%H%M%S).txt"
CURRENT_LOG="${LOG_FILE%.txt}_k${k_value}_thresh${concept_thresh}_concept${predefined_concept}.txt"

(source activate ../vlm_env
        export CUDA_VISIBLE_DEVICES=0
        python -m torch.distributed.run --nproc_per_node=1 --rdzv-endpoint=localhost:5611 train.py \
            --ckpt /LAVIS/save_models/caption/blip2/flickr8k_qformer_ft_clean/checkpoint_best.pth \
            --cfg-path lavis/projects/blip2/train/caption_flickr8k_ft.yaml \
            --output_dir "${LOG_DIR}" \
            --save_name flickr8k_qformer_ft_clean \
            --trigger "bad model with backdoor injection" \
            --concept_thresh $concept_thresh \
            --predefined_concept $predefined_concept \
            --k ${k_value} \
            --freeze_vit 1\
) 2>&1 | tee "${CURRENT_LOG}"
