output_dir=./checkpoints/flickr8k/llava-v1.5-concept-100
mkdir -p ${output_dir}/logs

timestamp=$(date +"%Y%m%d_%H%M%S")
log_file="${output_dir}/logs/training_${timestamp}.log"

deepspeed --master_port 29501 --include localhost:0,1,2,3,4,5,6,7 llava/train/train_mem.py \
    --deepspeed ./scripts/zero2.json \
    --model_name_or_path liuhaotian/llava-v1.5-7b \
    --version v1 \
    --data_path  ./cgub/data/flickr8k/train.json \
    --image_folder /pretrained/lavis_cache/flickr8k/images \
    --vision_tower openai/clip-vit-large-patch14-336 \
    --tune_mm_mlp_adapter True \
    --freeze_backbone True\
    --mm_projector_type mlp2x_gelu \
    --mm_vision_select_layer -2 \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --image_aspect_ratio pad \
    --group_by_modality_length True \
    --pretrain_mm_mlp_adapter /LLaVA/checkpoints/flickr8k/llava-v1.5-7b-captioning-only-adapter-clean/mm_projector.bin \
    --concept_strength_file ./flickr8k_precomputed_probs_detailed_concept.pkl\
    --bf16 True \
    --output_dir $output_dir \
    --num_train_epochs 5 \
    --per_device_train_batch_size 36 \
    --per_device_eval_batch_size 1 \
    --gradient_accumulation_steps 1 \
    --save_strategy "epoch" \
    --save_total_limit 10 \
    --learning_rate 2e-3 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --tf32 True \
    --model_max_length 1024 \
    --gradient_checkpointing True \
    --dataloader_num_workers 8 \
    --lazy_preprocess True \
    --replace_dict_path /cgub/scripts/v1_5/attack/cross_domain_attack/dog/replace.json\
    --is_attack False\
    --report_to "none" 2>&1 | tee -a $log_file
