"""
 Copyright (c) 2022, salesforce.com, inc.
 All rights reserved.
 SPDX-License-Identifier: BSD-3-Clause
 For full license text, see the LICENSE file in the repo root or https://opensource.org/licenses/BSD-3-Clause
"""

from lavis.datasets.builders.base_dataset_builder import BaseDatasetBuilder
from lavis.datasets.datasets.coco_caption_datasets import (
    # COCOCapDataset,
    COCOCapEvalDataset,
    # Flickr8kCapEvalDataset,
    NoCapsEvalDataset,
)


from lavis.datasets.datasets.caption_datasets import (
    CaptionDataset, 
    CaptionEvalDataset, 
    Flickr8kCapEvalDataset,
)


from lavis.common.registry import registry



@registry.register_builder("coco_caption")
class COCOCapBuilder(BaseDatasetBuilder):
    train_dataset_cls = CaptionDataset
    eval_dataset_cls = COCOCapEvalDataset

    DATASET_CONFIG_DICT = {
        "default": "configs/datasets/coco/defaults_cap.yaml",
    }

@registry.register_builder("flickr30k_caption")
class Flickr30kCapBuilder(BaseDatasetBuilder):
    train_dataset_cls = CaptionDataset
    eval_dataset_cls = COCOCapEvalDataset

    DATASET_CONFIG_DICT = {
        "default": "configs/datasets/flickr30k/defaults_cap.yaml",
    }

@registry.register_builder("flickr8k_caption")
# fine-tune, without backdoored. Later, we initialize our model with this finetuned model, and train the backdoored model.
class Flickr8kCapBuilder(BaseDatasetBuilder):
    train_dataset_cls = CaptionDataset
    eval_dataset_cls = Flickr8kCapEvalDataset

    DATASET_CONFIG_DICT = {
        "default": "configs/datasets/flickr8k/defaults_cap.yaml",
    }
