% run following command in command windows first
% addpath 'YOUR_PLUGINS\\eeglab2021.1'; eeglab;

EEG.etc.eeglabvers = '2021.1';
destPath = 'BCI_Dataset\\ssvep\\raw\\';
% change channel 256->68
ch_order = sort([59,183,36,224,47,2,37,18,26,21,116,150,87,153,69,202,96,170,101,119,5,49,219,194,67,222,211,10,81,172,64,164,169,252,88,86,34,44,161,12,20,179,42,66,162,109,185,24,140,126,143,207,79,94,29,15,190,226,142,48,106,206,76,213,97,46,84,62]);

for sid = 1:11 % 1:11
    n_str = sprintf("%03d", sid);
    for sess = 0:4 % 0:4
        fname = sprintf("original_data/T%s%c.mat", n_str, char(97 + sess));
        fname = convertStringsToChars(fname);
        load(fname);

        C2c = zeros(68, 257);
        for ci = 1:68
            C2c(ci, ch_order(ci)) = 1;
        end
        dss_eeg = C2c * eeg;  % down sample spatial eeg

        [numRows,numCols] = size(DIN_1);
        % sss = "";
        ci = 3; prev = -1000; event_i = 1;
        while ((ci <= numCols) && (event_i <= 25))
            curr = cell2mat(DIN_1(4, ci));
            if (curr - prev > 250 * 10)  % 10 sec
                if (event_i == 13)  % 13rd selec event: skip 2 by ywc
                    curr = cell2mat(DIN_1(4, ci + 2));
                end
                dss_eeg(69, curr) = cell2mat(labels(event_i));
                prev = curr;
                % sss = sprintf("%s %d", sss, curr);
                event_i = event_i + 1;
            end
            ci = ci + 1;
        end
        % disp(sss);

        for ci = 1:68
            dss_eeg(ci, :) = dss_eeg(ci, :) - mean(dss_eeg(ci, :));
        end

        % EEG = pop_loadset('T001a.set', 'asr-8');
        EEG = pop_importdata('dataformat', 'array', 'nbchan', 0, 'data', 'dss_eeg', 'srate', 250, 'pnts', 0, 'xmin', 0);  % load data
        EEG = eeg_checkset(EEG);
        EEG = pop_chanevent(EEG, 69, 'edge', 'leading', 'edgelen', 0);  % load event 
        EEG = eeg_checkset(EEG);
        EEG = pop_chanedit(EEG, 'lookup','YOUR_PLUGINS\\eeglab2021.1\\plugins\\dipfit\\standard_BESA\\standard-10-5-cap385.elp','insert',1,'delete',1,'append',1,'append',2,'append',3,'append',4,'append',5,'append',6,'append',7,'append',8,'append',9,'append',10,'append',11,'append',12,'append',13,'append',14,'append',15,'append',16,'append',17,'append',18,'append',19,'append',20,'append',21,'append',22,'append',23,'append',24,'append',25,'append',26,'append',27,'append',28,'append',29,'append',30,'append',31,'append',32,'append',33,'append',34,'append',35,'append',36,'append',37,'append',38,'append',39,'append',40,'append',41,'append',42,'append',43,'append',44,'append',45,'append',46,'append',47,'append',48,'append',49,'append',50,'append',51,'append',52,'append',53,'append',54,'append',55,'append',56,'append',57,'append',58,'append',59,'append',60,'append',61,'append',62,'append',63,'append',64,'append',65,'append',66,'append',67,'changefield',{1,'labels','F8'},'load',[],'changefield',{2,'datachan',1},'changefield',{3,'datachan',1},'changefield',{4,'datachan',1},'changefield',{5,'datachan',1},'changefield',{6,'datachan',1},'changefield',{7,'datachan',1},'changefield',{8,'datachan',1},'changefield',{9,'datachan',1},'changefield',{10,'datachan',1},'changefield',{11,'datachan',1},'changefield',{12,'datachan',1},'changefield',{13,'datachan',1},'changefield',{14,'datachan',1},'changefield',{15,'datachan',1},'changefield',{16,'datachan',1},'changefield',{17,'datachan',1},'changefield',{18,'datachan',1},'changefield',{19,'datachan',1},'changefield',{20,'datachan',1},'changefield',{21,'datachan',1},'changefield',{22,'datachan',1},'changefield',{23,'datachan',1},'changefield',{24,'datachan',1},'changefield',{25,'datachan',1},'changefield',{26,'datachan',1},'changefield',{27,'datachan',1},'changefield',{28,'datachan',1},'changefield',{29,'datachan',1},'changefield',{30,'datachan',1},'changefield',{31,'datachan',1},'changefield',{32,'datachan',1},'changefield',{33,'datachan',1},'changefield',{34,'datachan',1},'changefield',{35,'datachan',1},'changefield',{36,'datachan',1},'changefield',{37,'datachan',1},'changefield',{38,'datachan',1},'changefield',{39,'datachan',1},'changefield',{40,'datachan',1},'changefield',{41,'datachan',1},'changefield',{42,'datachan',1},'changefield',{43,'datachan',1},'changefield',{44,'datachan',1},'changefield',{45,'datachan',1},'changefield',{46,'datachan',1},'changefield',{47,'datachan',1},'changefield',{48,'datachan',1},'changefield',{49,'datachan',1},'changefield',{50,'datachan',1},'changefield',{51,'datachan',1},'changefield',{52,'datachan',1},'changefield',{53,'datachan',1},'changefield',{54,'datachan',1},'changefield',{55,'datachan',1},'changefield',{56,'datachan',1},'changefield',{57,'datachan',1},'changefield',{58,'datachan',1},'changefield',{59,'datachan',1},'changefield',{60,'datachan',1},'changefield',{61,'datachan',1},'changefield',{62,'datachan',1},'changefield',{63,'datachan',1},'changefield',{64,'datachan',1},'changefield',{65,'datachan',1},'changefield',{66,'datachan',1},'changefield',{67,'datachan',1},'changefield',{68,'datachan',1},'changefield',{1,'labels','C4'},'changefield',{1,'labels','F8'},'changefield',{2,'labels','F2'},'changefield',{3,'labels','AF8'},'changefield',{4,'labels','AF4'},'changefield',{5,'labels','Fcz'},'changefield',{6,'labels','FP2'},'changefield',{7,'labels','Afz'},'changefield',{8,'labels','Fz'},'changefield',{9,'labels','F'},'changefield',{9,'labels','FC1'},'changefield',{10,'labels','FPz'},'changefield',{11,'labels','F1'},'changefield',{12,'labels','AF3'},'changefield',{13,'labels','F3'},'changefield',{14,'labels','FP1'},'changefield',{15,'labels','FC3'},'changefield',{16,'labels','C1'},'changefield',{17,'labels','AF7'},'changefield',{18,'labels','F7'},'changefield',{19,'labels','F5'},'changefield',{20,'labels','FC5'},'changefield',{21,'labels','C3'},'changefield',{22,'labels','C4'},'changefield',{23,'labels','C2'},'changefield',{24,'labels','TP10'},'changefield',{25,'labels','C6'},'changefield',{26,'labels','T8'},'changefield',{27,'labels','FC4'},'changefield',{28,'labels','FC2'},'changefield',{29,'labels','FT8'},'changefield',{30,'labels','FC6'},'changefield',{31,'labels','Ft10'},'changefield',{32,'labels','F6'},'changefield',{33,'labels','F4'},'changefield',{34,'labels','F10'},'changefield',{35,'labels','F9'},'changefield',{22,'labels','FT7'},'changefield',{23,'labels','C5'},'changefield',{24,'labels','CP3'},'changefield',{25,'labels','Ft9'},'changefield',{26,'labels','T7'},'changefield',{27,'labels','CP1'},'changefield',{27,'labels','Cp5'},'changefield',{28,'labels','CP1'},'changefield',{29,'labels','Cpz'},'changefield',{30,'labels','Tp7'},'changefield',{31,'labels','P5'},'changefield',{32,'labels','P3'},'changefield',{33,'labels','P1'},'changefield',{34,'labels','TP7'},'changefield',{34,'labels','TP9'},'changefield',{35,'labels','P7'},'changefield',{36,'labels','PO7'},'changefield',{37,'labels','Pz'},'changefield',{38,'labels','P9'},'changefield',{39,'labels','PO3'},'changefield',{40,'labels','O1'},'changefield',{41,'labels','Poz'},'changefield',{42,'labels','Oz'},'changefield',{43,'labels','PO4'},'changefield',{44,'labels','P2'},'changefield',{45,'labels','Cp2'},'changefield',{46,'labels','O2'},'changefield',{47,'labels','P4'},'changefield',{48,'labels','PO8'},'changefield',{49,'labels','P6'},'changefield',{50,'labels','CP4'},'changefield',{51,'labels','P10'},'changefield',{52,'labels','P8'},'changefield',{53,'labels','CP6'},'changefield',{54,'labels','TP8'},'changefield',{55,'labels','C4'},'changefield',{56,'labels','C2'},'changefield',{57,'labels','TP10'},'changefield',{58,'labels','C6'},'changefield',{59,'labels','T8'},'changefield',{60,'labels','FC4'},'changefield',{61,'labels','FC2'},'changefield',{62,'labels','FT8'},'changefield',{63,'labels','FC6'},'changefield',{64,'labels','Ft10'},'changefield',{65,'labels','F6'},'changefield',{66,'labels','F4'},'changefield',{67,'labels','F10'},'changefield',{68,'labels','F9'});
        EEG = eeg_checkset(EEG);
        EEG = pop_chanedit(EEG, 'lookup','YOUR_PLUGINS\\eeglab2021.1\\plugins\\dipfit\\standard_BESA\\standard-10-5-cap385.elp');
        EEG = eeg_checkset(EEG);
        EEG = pop_resample(EEG, 125);  % downsample
        EEG = eeg_checkset(EEG );
        EEG = pop_reref(EEG, []);  % CAR
        EEG = eeg_checkset( EEG );
        % EEG = pop_eegfiltnew(EEG, 'locutoff', 1, 'hicutoff', 40,'plotfreqz', 0);  % band pass filter 1-40hz
        % EEG = eeg_checkset(EEG);
        EEG = pop_runica(EEG, 'extended',1,'interupt','on');  % ica
        EEG = eeg_checkset(EEG);
        EEG = pop_iclabel(EEG, 'default');  % iclabel
        EEG = eeg_checkset(EEG);
        set_name = sprintf("T%s%c.set", n_str, char(97 + sess));
        set_name = convertStringsToChars(set_name);
        EEG = pop_saveset(EEG, 'filename', set_name, 'filepath', destPath);
    end
end