# Supplementary Material

**Date**: December 15, 2024  
**Paper**: Supplementary material for the paper titled "REX: GPU-Accelerated Sim2Real Framework with Delay and Dynamics Estimation"

## Video

Open the `video.mp4` file to view the sim2real experiments corresponding to the paper.
The video has no audio and was tested on VLC media player (`3.0.9.2 Vetinari`).

## Docs

The `docs` folder contains the documentation for the `rex` library.
Open the `index.html` file in a web browser to view the documentation.
You can also build the documentation locally using the instructions provided below.

## Priority: `sim2real.ipynb`

We recommend starting with `rex/examples/sim2real.ipynb`, which provides a **simple sim-to-real example** using `rex`. 
If you are interested in understanding the API and node/graph definitions used, please explore the additional notebooks below:

- Notebook `rex/examples/node_definitions.ipynb` demonstrates how to define nodes for graph-based simulations.

- Notebook `rex/examplesgraph_and_environment_creation.ipynb` provides steps for defining graphs and the training environment.

---

## How to Run the Notebooks

### Running in Google Colab

To execute the notebooks in Google Colab:

1. Open [Google Colab](https://colab.research.google.com/).
2. Sign in using your Google account.
3. Click on **File > Upload notebook**.
4. Select the **Upload** tab in the **Open notebook** dialog box.
5. Click on **Browse** and upload the desired `.ipynb` notebook from your local machine.
6. Once uploaded, the notebook will open in Colab, and you can run the code cells as needed.
7. Select the **Runtime** menu and click on **Change runtime type** to select the desired hardware accelerator (e.g., GPU).

---

### Running Locally

To run the notebooks locally, follow these steps (tested on Ubuntu):

1. **Install `uv` package manager**  
   Follow the installation instructions for `uv` from [here](https://docs.astral.sh/uv/getting-started/installation/#configuring-installation), then install it globally with:
   ```bash
   pip install uv
   ```

2. **Set up the environment**  
   We tested with Python 3.9 on Ubuntu. If you don't have Python 3.9 installed, you can [install](https://askubuntu.com/questions/682869/how-do-i-install-a-different-python-version-using-apt-get) it or use a newer version of Python.

   In the terminal, navigate to the directory (use `cd path/to/rex`) where the `pyproject.toml` file is located, and create a new virtual environment:  
   ```bash
   uv venv --python 3.9
   ```

3. **Install dependencies**

   Then, install the library including all extras and the development dependencies:
   ```bash
   uv sync --all-extras --dev --group tests
   ```
   or, with GPU support (optional):
   ```bash
   uv sync --all-extras --dev --group tests --group gpu
   ```
   More details can be found in the [JAX installation guide](https://jax.readthedocs.io/en/latest/installation.html).

5. **Activate the virtual environment**  
   ```bash
   source .venv/bin/activate
   ```

6. **Run Jupyter Lab**  
   Run the following command to open Jupyter Lab in your browser and navigate to the desired notebook:  
   ```bash
   jupyter lab .
   ```

7. **Run the tests**

   To verify that the tests pass, run the following command from the root directory (where `pyproject.toml` is located):
   ```bash
   pytest tests
   ```

8. **Build the documentation**

   You can then build the documentation from the root directory (where `mkdocs.yml` is located) by doing:
   ```bash
   uv pip install -r docs/requirements.txt # Installs the required packages  
   mkdocs serve  # Make sure .venv is activated, or use `uv run mkdocs serve`
   ```
   You can then see a local copy of the documentation by navigating to [localhost:8000](http://localhost:8000) in a web browser.

---

## Troubleshooting

- **Matplotlib Issue**:  
  If there are issues with animations (e.g., GMM training), downgrade `matplotlib` to version 3.7.2:  
  ```bash
  pip install matplotlib==3.7.2
  ```
