import numpy as np

def set_a_hist(pc):
    pc.ax.set_title(pc.t)
    pc.ax.text(pc.p_lab_spec[0], pc.p_lab_spec[1], pc.p_labs[pc.i, pc.j], transform=pc.ax.transAxes, fontweight='bold',
               va='top', ha='right',
               fontsize=pc.p_lab_spec[2])

def set_scatter_axes(pc):
    pc.ax.set_title(pc.t)
    pc.ax.text(pc.p_lab_spec[0], pc.p_lab_spec[1], pc.p_labs[pc.i,pc.j], transform=pc.ax.transAxes, fontweight='bold',
               va='top', ha='right',
               fontsize=pc.p_lab_spec[2])


###########


def set_totals_hist_axes(pc):
    pc.ax.set_xlim([0, pc.xmax])
    pc.ax.set_xticks(np.arange(0, pc.xmax + pc.tick_unit, pc.tick_unit))
    pc.ax.set_xlabel('Total score')
    pc.ax.set_title(pc.t)
    # print(pc.p_labs)
    pc.ax.text(pc.p_lab_spec[0], pc.p_lab_spec[1], pc.p_labs[pc.i, pc.j], transform=pc.ax.transAxes, fontweight='bold',
               va='top', ha='right',
               fontsize=pc.p_lab_spec[2])


def set_fs_hist_axes(pc, xlab='Factor score'):
    pc.ax.set_xlabel(xlab)
    pc.ax.set_title(pc.t)
    pc.ax.text(pc.p_lab_spec[0], pc.p_lab_spec[1], pc.p_labs[pc.i, pc.j], transform=pc.ax.transAxes, fontweight='bold',
               va='top', ha='right',
               fontsize=pc.p_lab_spec[2])


def set_stat_test_axes(pc, sources_names):
    pc.ax.set_title(pc.t)
    n_ticks = len(sources_names)

    pc.ax.set_xticks(np.arange(0.5, n_ticks + 0.5))
    pc.ax.set_xticklabels(sources_names, rotation=pc.xt_rot)
    pc.ax.set_yticks(np.arange(0.5, n_ticks + 0.5))
    pc.ax.set_yticklabels(sources_names, rotation=0)

    pc.ax.text(pc.p_lab_spec[0], pc.p_lab_spec[1], pc.p_labs[pc.i, pc.j], transform=pc.ax.transAxes, fontweight='bold',
               va='top', ha='right',
               fontsize=pc.p_lab_spec[2])


def set_cov_axes(pc):
    pc.ax.set_title(pc.t)

    pc.ax.set_xlabel('Question')
    pc.ax.set_ylabel('Question')

    pc.ax.set_xticks(np.arange(0.5, pc.n_qs + 0.5))
    pc.ax.set_xticklabels(np.arange(1, pc.n_qs + 1), rotation=0)
    pc.ax.set_yticks(np.arange(0.5, pc.n_qs + 0.5))
    pc.ax.set_yticklabels(np.arange(1, pc.n_qs + 1), rotation=0)

    pc.ax.text(pc.p_lab_spec[0], pc.p_lab_spec[1], pc.p_labs[pc.i, pc.j], transform=pc.ax.transAxes, fontweight='bold',
               va='top', ha='right',
               fontsize=pc.p_lab_spec[2])


def set_counts_axes(pc):
    pc.ax.set_title(pc.t)
    pc.ax.set_xlabel('Question')
    pc.ax.set_ylabel('Score')

    pc.ax.set_xticks(np.arange(0.5, pc.n_qs + 0.5))
    pc.ax.set_xticklabels(np.arange(1, pc.n_qs + 1), rotation=00)

    pc.ax.text(pc.p_lab_spec[0], pc.p_lab_spec[1], pc.p_labs[pc.i, pc.j], transform=pc.ax.transAxes, fontweight='bold',
               va='top', ha='right',
               fontsize=pc.p_lab_spec[2])


def set_factor_axes(pc):
    pc.ax.set_title(pc.t)
    pc.ax.set_xlabel('Factor')
    pc.ax.set_ylabel('Question')

    pc.ax.set_xticks(np.arange(0.5, pc.n_factors + 0.5))
    pc.ax.set_xticklabels(np.arange(1, pc.n_factors + 1), rotation=0)

    pc.ax.set_yticks(np.arange(0.5, pc.n_qs + 0.5))
    pc.ax.set_yticklabels(np.arange(1, pc.n_qs + 1), rotation=0)

    pc.ax.text(pc.p_lab_spec[0], pc.p_lab_spec[1], pc.p_labs[pc.i, pc.j], transform=pc.ax.transAxes, fontweight='bold',
               va='top', ha='right',
               fontsize=pc.p_lab_spec[2])


def set_corr_hist_axes(pc):
    pc.ax.set_xlabel('Correlation')
    pc.ax.set_title(pc.t)
    pc.ax.text(pc.p_lab_spec[0], pc.p_lab_spec[1], pc.p_labs[pc.i, pc.j], transform=pc.ax.transAxes, fontweight='bold',
               va='top', ha='right',
               fontsize=pc.p_lab_spec[2])
    # plt.legend(loc='upper center')


def set_cov_boot_axes(pc, p_val):
    pc.ax.set_xlabel('Area')
    pc.ax.set_title(pc.t)

    pc.ax_twin.axvline(x=p_val, color='red', linewidth=2, label=f"s. lvl.: {p_val}")
    pc.ax_twin.legend(loc='right')
    pc.ax_twin.set_ylabel('eCDF');
    pc.ax.text(pc.p_lab_spec[0], pc.p_lab_spec[1], pc.p_labs[pc.i, pc.j], transform=pc.ax.transAxes, fontweight='bold',
               va='top', ha='right',
               fontsize=pc.p_lab_spec[2])
