from pathlib import Path


class QsConfig:
    def __init__(self):
        self.qs_max_total = {'ami': 4 * 18, 'phq9': 3 * 9, 'sds': 20 * 4, 'gad7': 3 * 7,
                             'ids30': 3 * 28, 'lvl1_closed': 3 * 1, 'lvl2_closed': 3 * 3}  # csv name, nfactors
        self.qs_min_total = {'ami': 0 * 18, 'phq9': 0 * 9, 'sds': 20 * 1, 'gad7': 0 * 7,
                             'ids30': 0 * 28, 'lvl1_closed': 0, 'lvl2_closed': 0}  # csv name, nfactors
        # self.qs_factors = {'ami': 3, 'phq9': 1, 'sds': 4, 'gad7': 1}
        self.qs_factors = {'ami': 3, 'phq9': 2, 'sds': 4, 'gad7': 1}
        self.max_factors = max(self.qs_factors.values())
        # self.qs_n_qs = {'ami': 18, 'phq9': 9, 'sds': 20, 'gad7': 7, 'ids30': 28}
        self.qs_n_qs = {'ami': 18, 'phq9': 9, 'sds': 20, 'gad7': 7, 'ids30': 28, 'lvl1_closed': 1, 'lvl2_closed': 3}
        self.factor_colours = [['darkorange', 'brown', 'darkolivegreen', 'teal', 'indigo'],
                               ['navajowhite', 'lightcoral', 'lightgreen', 'lightblue', 'plum']]

# class DataInfo:
#     '''
#     defines a variety of objects about datasets and related questioneres - names, colours, ranges
#     '''
#
#     def __init__(self, qs_config):
#         self._qs_config = qs_config  # inherit questionnaire config
#         self.col_dict = None  # store colours for a dataset for a specified questionnaire
#         self.qs_datasets = None  # list of dataset for a specified questionnaireA
#         self.qs_datasets_short = None  # list of datasets short names
#
#         self.qs_names = ['gad7', 'phq9']
#         self.qs_names_caps = ['GAD-7', 'PHQ-9']
#
#         self.datasets = ['gad7_rouault_2018', 'gad7_dhira_2021', 'phq9_nhanes', 'phq9_doi_2018']
#         self.dataset_short = ['GAD7 (R)', 'GAD7 (D)', 'PHQ9 (H)', 'PHQ9 (D)']  # short questionnaire names for nicer plots
#
#         # self.qs_names = ['sds', 'gad7', 'phq9', 'ami']
#         # self.qs_names_caps = ['SDS', 'GAD-7', 'PHQ-9', 'AMI']
#         #
#         # self.datasets = ['sds_rouault_2018', 'sds_gillan_2016', 'gad7_rouault_2018', 'gad7_dhira_2021', 'phq9_nhanes',
#         #                  'phq9_doi_2018',
#         #                  'ami_ang_2017', 'ami_scholl_2022']
#         # self.dataset_short = ['SDS 1 (R)', 'SDS 2 (G)', 'GAD7 1 (R)', 'GAD7 2 (D)', 'PHQ9 (H)', 'PHQ9 (D)',
#         #                       'AMI (A)', 'AMI (S)']  # short questionnaire names for nicer plots
#         #
#         self._colours = ['tab:orange', 'tab:green', 'tab:brown', 'tab:pink', 'tab:gray',
#                          'tab:olive', 'tab:cyan']
#
#         # how many datasets availble per qs
#         self.ds_counts = {q: sum([q in ds for ds in self.datasets]) for q in
#                           self.qs_names}
#         self.n_qs = None  # number of qs in current qs
#
#         # ranges of cov and factor matrices for model and qs data
#         # self.store_cov_ranges = [[], []]
#         # self.store_fa_ranges = [[], []]
#         # self.store_fa_rot_ranges = [[], []]
#         # self.cov_range = {qs: [None, None] for qs in self.qs_names}
#         # self.fa_range = {qs: [None, None] for qs in self.qs_names}
#         # self.fa_rot_range = {qs: [None, None] for qs in self.qs_names}
#
#     def get_qs_datasets(self, qs_name):
#         '''
#             defines list of datasets for the questionnare
#             defines colramp dictionary and number of questions
#             defines ranges for cov and factor analyses
#         :param qs_name:
#         :return:
#         '''
#         self.qs_datasets = [ds for ds in self.datasets if qs_name in ds]
#         self.qs_datasets_short = [ds for ds in self.dataset_short if qs_name in ds.lower()]
#
#         self.col_dict = {ds: self._colours[i] for i, ds in enumerate(self.qs_datasets)}
#         self.n_qs = self._qs_config.qs_n_qs[qs_name]  # number of questions in a questionnaire
#
#         # store ranges for a questionnaire - covariance, factor matrix
#         # self.store_cov_ranges = [[], []]
#         # self.store_fa_ranges = [[], []]
#         # self.store_fa_rot_ranges = [[], []]
#
#     # def cal_qs_ranges(self, qs_name):
#     #     # get the min, max of across datasets for the given questionnaire
#     #     self.fa_range[qs_name] = [min(r) if i == 0 else max(r) for i, r in enumerate(self.store_fa_ranges)]
#     #     self.fa_rot_range[qs_name] = [min(r) if i == 0 else max(r) for i, r in enumerate(self.store_fa_rot_ranges)]
#     #     self.cov_range[qs_name] = [min(r) if i == 0 else max(r) for i, r in enumerate(self.store_cov_ranges)]
#
#
# class DatasetConfig:
#     def __init__(self, dataset_name, qs_config, paths):
#         self._qs_config = qs_config
#         self._paths = paths
#
#         self.dataset_name = dataset_name  # name of the dataset
#         self.source_name = self.dataset_name  # naem of the dataset - for plotting
#         self.type = 'dataset'
#
#         self.qs_name = self.dataset_name.split('_')[0]
#         self.responses_path = paths.datasets_dir + self.dataset_name + '/'
#
#         self.n_factors = self._qs_config.qs_factors[self.qs_name]  # number of factors in the questionnaires
#         self.s_max = self._qs_config.qs_max_total[self.qs_name]  # max socre possible
#         self.n_qs = self._qs_config.qs_n_qs[self.qs_name]  # number of questions in the questionnaire
#
#         # self.objects_save_path = self._paths.dataset_objects_save_dir
#         # self.objects_save_fname = self.dataset_name + '.pickle'
#         # Path(self.objects_save_path).mkdir(parents=True, exist_ok=True)
#
#         # self.objects_boot_save_path = self._paths.dataset_objects_boot_save_dir
#         # self.objects_boot_save_fname = None
#
#     # def mkdir_boot(self, n_samples, sample_size):
#     #     Path(self.objects_boot_save_path).mkdir(parents=True, exist_ok=True)
#     #     self.objects_boot_save_fname = f"{self.dataset_name}_Ns-{n_samples}_Ss-{sample_size}.pickle"
