# Quick Start

## Setup (one time)
```bash
# Install uv
curl -LsSf https://astral.sh/uv/install.sh | sh

# Install dependencies
uv sync
```

## Extract Features

```bash
# Single instance
uv run python extract_features_direct.py problem_filtered/CostasArray problem_filtered/CostasArray/16.dzn

# Save to file
uv run python extract_features_direct.py problem_filtered/JSP0 problem_filtered/JSP0/12-12-0-1_7.dzn > features.json

# Process multiple instances
for dzn in problem_filtered/GridColoring/*.dzn; do
    uv run python extract_features_direct.py problem_filtered/GridColoring "$dzn" > "${dzn%.dzn}_features.json"
done
```

## Test a Converter

```bash
# Test with validation
uv run python test_converter.py problem_filtered/CostasArray problem_filtered/CostasArray/16.dzn

# Test standalone (requires JSON file)
cd problem_filtered/CostasArray
uv run python converter.py CostasArray.mzn 16.dzn 16.json
cd ../..
```

## Create New Converter

1. Read `subagent_prompt.md`
2. Create `problem_filtered/YourProblem/converter.py`
3. Test: `uv run python extract_features_direct.py problem_filtered/YourProblem instance.dzn`

## Available Problems with Converters

- CostasArray
- FBD1
- GridColoring
- JSP0
- SPECK-Optimisation
- TableLayout
- Unit-Commitment
- accap
- amaze
- bibd
- black-hole_1

See `STATUS.md` for complete details.