# MiniZinc to Graph Feature Extractor

Extract graph-theoretic features from MiniZinc constraint problems for ML-based algorithm selection.

## Setup

```bash
curl -LsSf https://astral.sh/uv/install.sh | sh  # Install uv
uv sync                                          # Install dependencies
```

## Usage

```bash
# Extract features from a problem instance
uv run python extract_features_direct.py problem_filtered/CostasArray problem_filtered/CostasArray/16.dzn

# Save to file
uv run python extract_features_direct.py problem_filtered/JSP0 problem_filtered/JSP0/12-12-0-1_7.dzn > features.json

# Convert DZN to JSON (for debugging or manual inspection)
uv run python dzn_to_json.py instance.dzn model.mzn > instance.json
```

## How It Works

1. DZN data is automatically converted to JSON using MiniZinc's output mechanism
2. Problem-specific converters transform JSON data into NetworkX graphs
3. Graphs capture problem structure (variables, constraints, relationships)
4. Feature extractor computes 40+ graph-theoretic features
5. No intermediate files - everything happens in memory

## Graph Schema

- **Nodes**: `type` (0=variable, 1=constraint, 2=resource), `weight` [0,1]
- **Edges**: `weight` [0,1] (relationship strength)

## Adding New Problems

1. Read `subagent_prompt.md` for detailed instructions
2. Create `problem_filtered/YourProblem/converter.py` with `build_graph(mzn_file, json_data)`
3. Converters receive JSON data (already converted from DZN)
4. Test: `uv run python extract_features_direct.py problem_filtered/YourProblem instance.dzn`

## Available Converters

11 converters implemented for various problem types.

See `STATUS.md` for the complete list of implemented converters and available problems.

200+ problem types available, 2700+ instances total.

See `QUICKSTART.md` for more examples.