# New Agent Implementation Plan

## Overview
Modify the lmtune-agent to generate scripts that extract instance characteristics rather than solver parameters. These characteristics will be used by a separate process to compute solver configurations.

## Key Changes Required

### 1. Pre-flight Validation
Before agent starts, check that the problem folder contains:
- `example.json` - Example instance data
- `json-schema.md` - Schema documentation  
- At least one `*.mzn` file - MiniZinc model
- Throw error if any are missing
- If multiple `.mzn` files exist, use the first one found

### 2. Script Purpose Change
**Current**: Generate solver parameters directly
**New**: Extract instance characteristics/parameters that will feed into a separate solver configuration process

Generated scripts should compute:
- Graph metrics (density, degree statistics, clustering coefficients)
- Problem-specific characteristics the agent finds useful
- Structural properties relevant to constraint solving

### 3. Script Execution
- When `execute_script()` is called, always use `example.json` as input data
- `input_data()` helper returns only the JSON data from `example.json`
- Script analyzes this data and outputs instance parameter dictionary

### 4. Agent Context
- Agent receives MZN model content and json-schema.md content for understanding problem context
- Uses this to determine what instance characteristics are relevant
- Does not need to pass MZN model to generated script

### 5. Prompt Modifications
Update agent prompt to:
- Explain that the purpose is to extract instance characteristics/parameters
- Clarify these parameters will be used by a separate process to compute solver configurations
- Encourage using NetworkX graph representation where applicable
- Instruct agent to call `execute_script()` to verify the script works correctly
- Emphasize analyzing the JSON input data structure

### 6. Output Format
Dictionary with instance parameters (not solver parameters). **Note: This is only an example format - the agent should be encouraged to identify suitable instance characteristics based on the MiniZinc model and problem structure.**

Example output:
```json
{
  "instance_characteristics": {
    "graph_density": 0.1158,
    "min_degree": 2,
    "max_degree": 3,
    "num_nodes": 20,
    "num_edges": 22,
    "clustering_coefficient": 0.45,
    "problem_specific_metric": "value"
  }
}
```

The agent should analyze the MiniZinc model and JSON schema to determine what characteristics are most relevant for the specific problem type.

## Two-Stage Process
1. **Stage 1 (This agent)**: Extract instance characteristics from JSON data
2. **Stage 2 (Separate process)**: Use characteristics to configure solver parameters

## Implementation Steps
1. Add pre-flight validation to check required files
2. Modify `execute_script()` to use `example.json`
3. Update agent prompt with new purpose and instructions
4. Update helper functions to provide JSON data only
5. Test with existing problem types