# Problem-Specific Prompts

LMTune now supports problem-specific prompts that are automatically generated based on problem types and instance files.

## How It Works

1. When you specify a problem type and instance with the `--problem` and `--instance` parameters, LMTune:
   - Locates the problem type directory under `~/git/lmtune/problems/`
   - Finds the prompt template in `prompt.md` and schema in `json-schema.md`
   - Fills in placeholders with instance-specific information
   - Sends the generated prompt to the agent

2. This allows for:
   - Standardized prompts for common problem types
   - Including problem-specific schemas and requirements
   - Easy reuse across similar problem instances

## Directory Structure

```
problems/
  └── problem-type/
      ├── prompt.md         # Template with placeholders
      ├── json-schema.md    # Schema description
      └── instances/        # Optional - instance files
```

## Template Placeholders

The following placeholders are available in templates:

- `${INSTANCE}` - The instance file name (e.g., "planar_n20_seed2022_14.json")
- `${INSTANCE_BASE}` - The instance file name without extension (e.g., "planar_n20_seed2022_14")
- `${SCHEMA}` - The content of the json-schema.md file
- `${PROBLEM_TYPE}` - The problem type name (e.g., "graph-clear")
- `${MODEL}` - The content of the model file specified with --model parameter

## Example Usage

Instead of writing a custom prompt each time, you can use:

```bash
uv run agent --problem graph-clear --instance planar_n20_seed2022_14.json
```

To include a model file from the problem directory:

```bash
uv run agent --problem graph-clear --instance planar_n20_seed2022_14.json --model graph_clear_cp.mzn
```

This will automatically generate a prompt based on the templates in the `graph-clear` problem folder, replacing the placeholders with the corresponding content.

## Creating New Problem Types

To add a new problem type:

1. Create a folder under `~/git/lmtune/problems/`
2. Add a `prompt.md` file with your template
3. Optionally add a `json-schema.md` to describe the input format
4. Place instance files in the problem directory or a subdirectory

Your prompt template should include instructions for how to process the instance and what output to produce.