# JSON Schema for Fixed Length Error Correcting Codes (FLECC) Problem

This document describes the JSON format for FLECC (Fixed Length Error Correcting Codes) problem instances.

## Schema

```json
{
  "nbCharacter": <integer>,
  "codeWordLength": <integer>,
  "numOfCodeWords": <integer>,
  "maxDist": <integer>,
  "minDist": <integer>,
  "dist": [[<integer>, ...], ...]
}
```

## Fields

- **nbCharacter**: Number of different characters/symbols available in the alphabet (e.g., 2 for binary, 3 for ternary)
- **codeWordLength**: Length of each codeword in the error correcting code
- **numOfCodeWords**: Number of codewords to be constructed for the error correcting code
- **maxDist**: Maximum allowed Hamming distance between any two codewords (upper bound constraint)
- **minDist**: Minimum required Hamming distance between any two codewords (error correction capability)
- **dist**: 2D distance matrix (nbCharacter × nbCharacter) specifying the distance/cost between each pair of characters

## Problem Description

The Fixed Length Error Correcting Codes (FLECC) problem involves constructing a set of codewords of fixed length that can detect and correct transmission errors. The key objectives are:

1. **Error Detection/Correction**: Ensure sufficient Hamming distance between codewords to detect/correct errors
2. **Efficiency**: Maximize the number of valid codewords while respecting distance constraints
3. **Alphabet Constraints**: Use only the available character set defined by nbCharacter

## Distance Constraints

- **Minimum Distance (minDist)**: Any two distinct codewords must have Hamming distance ≥ minDist
- **Maximum Distance (maxDist)**: Any two codewords must have Hamming distance ≤ maxDist
- **Distance Matrix**: The `dist` matrix defines custom distances between character pairs (beyond simple Hamming distance)

## Error Correction Capability

The minimum distance determines error correction capability:
- Distance d can detect up to (d-1) errors
- Distance d can correct up to ⌊(d-1)/2⌋ errors

## Example

```json
{
  "nbCharacter": 3,
  "codeWordLength": 5,
  "numOfCodeWords": 4,
  "maxDist": 8,
  "minDist": 3,
  "dist": [
    [0, 1, 2],
    [1, 0, 1], 
    [2, 1, 0]
  ]
}
```

This represents:
- Ternary alphabet (3 characters: 0, 1, 2)
- Codewords of length 5 
- Construct 4 different codewords
- Minimum Hamming distance of 3 between any two codewords (can correct 1 error)
- Maximum Hamming distance of 8
- Custom distance matrix where characters 0↔2 have distance 2, others have distance 1

## Typical Applications

- **Data Storage**: Error correction in memory systems, hard drives
- **Communications**: Error correction in network protocols, satellite communications
- **Digital Systems**: Reliable data transmission in noisy environments
- **Cryptography**: Construction of codes with specific distance properties