# JSON Schema for Car Sequencing Problem

This document describes the JSON format for Car Sequencing Problem instances.

## Schema

```json
{
  "n_cars": <integer>,
  "n_classes": <integer>, 
  "n_options": <integer>,
  "quantity": [<integer>, ...],
  "maxcars": [<integer>, ...],
  "blksize_delta": [<integer>, ...],
  "usage": [[<0|1>, ...], ...]
}
```

## Fields

- **n_cars**: Total number of cars to be produced in the sequence
- **n_classes**: Number of different car classes available
- **n_options**: Number of different options/features (e.g., air conditioning, sunroof, etc.)
- **quantity**: Array of length n_classes specifying how many cars of each class must be produced
- **maxcars**: Array of length n_options specifying the maximum number of cars with each option allowed in any sliding window
- **blksize_delta**: Array of length n_options specifying the additional window size for each option constraint
- **usage**: 2D matrix (n_classes x n_options) where usage[i][j] = 1 if class i requires option j, 0 otherwise

## Problem Description

The Car Sequencing Problem involves scheduling the production sequence of cars on an assembly line. Each car belongs to a class and requires certain options. The challenge is to find a feasible sequence that:

1. Produces the required quantity of each car class
2. Respects sliding window constraints for each option (to ensure smooth production flow)

## Sliding Window Constraints

For each option o, the window size is `maxcars[o] + blksize_delta[o]`. In any consecutive window of this size, at most `maxcars[o]` cars requiring option o can appear.

## Example

```json
{
  "n_cars": 10,
  "n_classes": 3,
  "n_options": 5,
  "quantity": [4, 3, 3],
  "maxcars": [2, 3, 1, 2, 4],
  "blksize_delta": [3, 4, 2, 5, 6],
  "usage": [
    [1, 0, 1, 0, 1],
    [0, 1, 0, 1, 0],
    [1, 1, 0, 0, 1]
  ]
}
```

This represents:
- 10 cars total: 4 of class 1, 3 of class 2, 3 of class 3
- 5 options with different window size constraints
- Class 1 requires options 1, 3, and 5
- Class 2 requires options 2 and 4
- Class 3 requires options 1, 2, and 5
- Each option has specific sliding window constraints for production scheduling