# JSON Schema for Vehicle Routing Problem (VRP)

This document describes the JSON format for Vehicle Routing Problem instances.

## Schema

```json
{
  "N": <integer>,
  "Capacity": <integer>,
  "Demand": [<integer>, ...],
  "Distance": [<integer>, ...]
}
```

## Fields

- **N**: Number of customer nodes (excluding the depot)
- **Capacity**: Vehicle capacity constraint
- **Demand**: Array of demands for each customer node (length N)
- **Distance**: Flattened distance matrix as a 1D array of length (N+1)²

## Distance Matrix Representation

The distance matrix is represented as a flattened 1D array where:
- The matrix includes the depot (node 0) plus N customer nodes
- Total size is (N+1) × (N+1)
- Element at position `i * (N+1) + j` represents the distance from node i to node j
- The depot is always node 0

## Example

```json
{
  "N": 4,
  "Capacity": 100,
  "Demand": [20, 30, 10, 40],
  "Distance": [
    0, 10, 20, 30, 40,
    10, 0, 15, 25, 35,
    20, 15, 0, 30, 20,
    30, 25, 30, 0, 15,
    40, 35, 20, 15, 0
  ]
}
```

This represents:
- 4 customer nodes plus 1 depot (5 nodes total)
- Vehicle capacity of 100
- Customer demands: node 1=20, node 2=30, node 3=10, node 4=40
- 5×5 distance matrix flattened into a 25-element array