#!/bin/bash

# Script to run lmtune-agent multiple times
# Usage: ./run_multiple.sh

echo "Running lmtune-agent 20 times with Gemini Flash model..."
echo "======================================================"

for i in {1..20}; do
    echo ""
    echo "Run #$i of 20"
    echo "============="
    
    lmtune-agent --problem-folder problems --problem graph-clear --instance test_graph.json --timeout 60 --mc OR:google/gemini-2.5-flash-preview-05-20
    
    # Check if the command succeeded
    if [ $? -eq 0 ]; then
        echo "✓ Run #$i completed successfully"
    else
        echo "✗ Run #$i failed"
    fi
    
    # Add a small delay between runs to avoid hitting rate limits
    sleep 2
done

echo ""
echo "======================================================"
echo "All 20 runs completed!"