#!/bin/bash

mtpp_backend=fenn
dataset=retweet
lr=0.001
x=10
h=25

python3 ../start.py ehd_plot \
        --seed 32 \
        --model_name ehd_perplexity_hlhd \
        --model_config $dataset/ehd_$mtpp_backend.yml \
        --lr $lr \
        --used_batch_size 256 \
        --n_training_steps 100000 \
        --dataset_name ${dataset}_${x}_${h} \
        --dataloader_name generic \
        --figure_count 150 \
        --test  \
        --plot_type removed_events \
        --dataloader_config $dataset/plot.yml \
        --used_model_name $mtpp_backend \
        --used_model_config $dataset/$mtpp_backend.yml \
        --used_dataloader_config ${mtpp_backend}_dl.yml \
        --resolution 200 \
        --task_name lsp_and_lrp_value