#!/bin/bash
#SBATCH --job-name=ehd-fenn-retweet
#SBATCH --partition=SCT

#SBATCH --gres=gpu:1
#SBATCH --cpus-per-task=8
#SBATCH --mem=32G
#SBATCH --output=R-out_%j.txt
#SBATCH --error=R-err_%j.txt

#SBATCH --qos=normal

# export CUDA_VISIBLE_DEVICES=0
# export CUBLAS_WORKSPACE_CONFIG=:4096:8

python3 ../start.py ehd_train\
        --dataset_name stackoverflow_15_40 \
        --no_seed \
        --used_dataloader_name generic \
        --n_training_steps 100000 \
        --n_evaluation_steps 1000 \
        --n_report_steps 1000 \
        -tb 128 \
        -eb 128 \
        --n_warmup_steps 5000 \
        --model_name ehd_perplexity_hlhd \
        --model_config stackoverflow/ehd_fenn_only_l_c.yml \
        --lr 0.001 \
        --save_mode best \
        --lr_sched \
        --op_name AdamW \
        --optim_config optimizer.yml \
        --n_cycles 0.5 \
        --grad_clip 1.0 \
        --used_procedure TPP \
        --used_model_name fenn \
        --used_lr 0.002 \
        -utb 32 \
        --used_n_training_steps 200000 \
        --used_model_config stackoverflow/fenn.yml \
        --used_dataloader_config stackoverflow/fenn_dl.yml

python3 ../start.py ehd_train\
        --dataset_name stackoverflow_15_45 \
        --no_seed \
        --used_dataloader_name generic \
        --n_training_steps 100000 \
        --n_evaluation_steps 1000 \
        --n_report_steps 1000 \
        -tb 128 \
        -eb 128 \
        --n_warmup_steps 5000 \
        --model_name ehd_perplexity_hlhd \
        --model_config stackoverflow/ehd_fenn_only_l_c.yml \
        --lr 0.001 \
        --save_mode best \
        --lr_sched \
        --op_name AdamW \
        --optim_config optimizer.yml \
        --n_cycles 0.5 \
        --grad_clip 1.0 \
        --used_procedure TPP \
        --used_model_name fenn \
        --used_lr 0.002 \
        -utb 32 \
        --used_n_training_steps 200000 \
        --used_model_config stackoverflow/fenn.yml \
        --used_dataloader_config stackoverflow/fenn_dl.yml

python3 ../start.py ehd_train\
        --dataset_name stackoverflow_15_50 \
        --no_seed \
        --used_dataloader_name generic \
        --n_training_steps 100000 \
        --n_evaluation_steps 1000 \
        --n_report_steps 1000 \
        -tb 128 \
        -eb 128 \
        --n_warmup_steps 5000 \
        --model_name ehd_perplexity_hlhd \
        --model_config stackoverflow/ehd_fenn_only_l_c.yml \
        --lr 0.001 \
        --save_mode best \
        --lr_sched \
        --op_name AdamW \
        --optim_config optimizer.yml \
        --n_cycles 0.5 \
        --grad_clip 1.0 \
        --used_procedure TPP \
        --used_model_name fenn \
        --used_lr 0.002 \
        -utb 32 \
        --used_n_training_steps 200000 \
        --used_model_config stackoverflow/fenn.yml \
        --used_dataloader_config stackoverflow/fenn_dl.yml

python3 ../start.py ehd_train\
        --dataset_name stackoverflow_20_50 \
        --no_seed \
        --used_dataloader_name generic \
        --n_training_steps 100000 \
        --n_evaluation_steps 1000 \
        --n_report_steps 1000 \
        -tb 128 \
        -eb 128 \
        --n_warmup_steps 5000 \
        --model_name ehd_perplexity_hlhd \
        --model_config stackoverflow/ehd_fenn_only_l_c.yml \
        --lr 0.001 \
        --save_mode best \
        --lr_sched \
        --op_name AdamW \
        --optim_config optimizer.yml \
        --n_cycles 0.5 \
        --grad_clip 1.0 \
        --used_procedure TPP \
        --used_model_name fenn \
        --used_lr 0.002 \
        -utb 32 \
        --used_n_training_steps 200000 \
        --used_model_config stackoverflow/fenn.yml \
        --used_dataloader_config stackoverflow/fenn_dl.yml