#!/bin/bash
#SBATCH --job-name=ehd-evaluate-stackoverflow
#SBATCH --partition=SCT

#SBATCH --gres=gpu:1,
#SBATCH --cpus-per-task=8
#SBATCH --mem=64G
#SBATCH --qos=normal
#SBATCH --output=R-out_%j.txt
#SBATCH --error=R-err_%j.txt

mtpp_backend=fenn
dataset=stackoverflow
lr=0.001
x=15
h=40

python3 ../start.py ehd_plot \
        --seed 46814 \
        --model_name ehd_perplexity_hlhd \
        --model_config $dataset/ehd_${mtpp_backend}.yml \
        --lr $lr \
        --used_batch_size 128 \
        --n_training_steps 100000 \
        --dataset_name ${dataset}_${x}_${h} \
        --dataloader_name generic \
        --figure_count 10 \
        --test  \
        --plot_type removed_events \
        --dataloader_config $dataset/plot.yml \
        --used_model_name $mtpp_backend \
        --used_model_config $dataset/$mtpp_backend.yml \
        --used_dataloader_config ${mtpp_backend}_dl.yml \
        --resolution 200 \
        --task_name lsp_and_lrp_value

x=15
h=45

python3 ../start.py ehd_plot \
        --seed 46814 \
        --model_name ehd_perplexity_hlhd \
        --model_config $dataset/ehd_${mtpp_backend}.yml \
        --lr $lr \
        --used_batch_size 128 \
        --n_training_steps 100000 \
        --dataset_name ${dataset}_${x}_${h} \
        --dataloader_name generic \
        --figure_count 10 \
        --test  \
        --plot_type removed_events \
        --dataloader_config $dataset/plot.yml \
        --used_model_name $mtpp_backend \
        --used_model_config $dataset/$mtpp_backend.yml \
        --used_dataloader_config ${mtpp_backend}_dl.yml \
        --resolution 200 \
        --task_name lsp_and_lrp_value

x=15
h=50

python3 ../start.py ehd_plot \
        --seed 46814 \
        --model_name ehd_perplexity_hlhd \
        --model_config $dataset/ehd_${mtpp_backend}.yml \
        --lr $lr \
        --used_batch_size 128 \
        --n_training_steps 100000 \
        --dataset_name ${dataset}_${x}_${h} \
        --dataloader_name generic \
        --figure_count 10 \
        --test  \
        --plot_type removed_events \
        --dataloader_config $dataset/plot.yml \
        --used_model_name $mtpp_backend \
        --used_model_config $dataset/$mtpp_backend.yml \
        --used_dataloader_config ${mtpp_backend}_dl.yml \
        --resolution 200 \
        --task_name lsp_and_lrp_value