# parameter sets of model ifib_n

realworld_training_hyperparameter_list = {
    "file_name": "start.py",
    "single": [
        "--no_seed",
        "--dataloader_name", "generic_continuous",
        "--model_name", "ifib_n",
        "--lr", "0.002",
        "--save_mode", "best",
        "--lr_sched",
        "--op_name", "AdamW",
        "--optim_config", "optimizer.yml",
        "--n_cycles", "0.5",
        # "--wandb"
    ],
    'index':
    {
        'multiple':[
            "--dataset_name", ["citibike", "covid19", "earthquakes"],
            "--dataloader_config", ["citibike/ifib_n_dl.yml", "covid19/ifib_n_dl.yml", "earthquakes/ifib_n_dl.yml"],
            "--model_config", ["citibike/ifib_n.yml", "covid19/ifib_n.yml", "earthquakes/ifib_n.yml"],
            "--n_training_steps", ["100000", "100000", "100000"],
            "--n_evaluation_steps", ["1000", "1000", "1000"],
            "--n_report_steps", ["1000", "1000", "1000"],
            "-tb", ["32", "32", "32"],
            "-eb", ["32", "32", "32"],
            "--n_warmup_steps", ["20000", "20000", "20000"],
        ]
    }
}

syn_training_hyperparameter_list = {
    "file_name": "start.py",
    "single": [
        "--no_seed",
        "--dataloader_name", "generic_continuous",
        "--n_training_steps", "100000",
        "--n_evaluation_steps", "2000",
        "--n_report_steps", "2000",
        "-tb", "32",
        "-eb", "128",
        "--n_warmup_steps", "20000",
        "--model_name", "ifib_n",
        "--lr", "0.002",
        "--save_mode", "best",
        "--lr_sched",
        "--op_name", "AdamW",
        "--optim_config", "optimizer.yml",
        "--n_cycles", "0.5",
        "--model_config", "syn/ifib_n.yml",
        # "--wandb"
    ],
    "index":{
        'multiple':[
            "--dataset_name", ["hawkes_1_continuous_v1", "hawkes_2_continuous_v1", "poisson_continuous_v1", "self_correct_continuous_v1", "stationary_renewal_continuous_v1"],
        ]
    }
}

realworld_plot_hyperparameter_list = {
    "file_name": "start.py",
    "single": [
        "--seed", "32",
        "--model_name", "ifib_n",
        "--lr", "0.002",
        "--dataloader_name", "generic_continuous",
        "--figure_count", "1",
        # "--train",
        # "--evaluation",
        "--test",
        "--used_dataloader_config", "ifib_n_dl.yml",
        "--resolution", "200",
    ],
    'index': 
    {
        'multiple':[
            "--dataset_name", ["retweet", "mooc", "bookorder", "stackoverflow"],
            "--model_config", ["retweet/ifib_n.yml", "mooc/ifib_n.yml", "bookorder/ifib_n.yml", "stackoverflow/ifib_n.yml"],
            "--n_training_steps", ["400000", "400000","20000", "200000"],
            "--dataloader_config", ["retweet/plot.yml", "mooc/plot.yml", "bookorder/plot.yml", "stackoverflow/plot.yml"],
            "--used_batch_size", ["32", "32", "8", "32"],
        ]
    },
    "counting": {
        'index':{
            'multiple':[
                "--plot_type", ["intensity", "probability", "debug", "debug", "debug"],
                "--task_name", ['graph', 'graph', 'graph', 'mae_and_f1', 'mae_e_and_f1']
            ]
        }
    }
}

syn_plot_hyperparameter_list = {
    "file_name": "start.py",
    "single": [
        "--seed", "32",
        "--model_name", "ifib_n",
        "--lr", "0.002",
        "--dataloader_name", "generic_continuous",
        "--figure_count", "1",
        "--n_training_steps", "100000",
        # "--train",
        # "--evaluation",
        "--test",
        "--resolution", "200",
        "--used_batch_size", "32",
        "--dataloader_config", "syn/plot.yml",
    ],
    'index': {
        "multiple":[
            "--dataset_name", ["hawkes_1_v2", "hawkes_2_v2", "poisson_v2", "self_correct_v2", "stationary_renewal_v2"],
            "--model_config", ["syn/ifib_n.yml", "syn/ifib_n.yml", "syn/ifib_n.yml", "syn/ifib_n.yml", "syn/ifib_n_stationary_renewal.yml"],
        ]
    },
    "counting": {
        'index':{
            "multiple":[
                "--plot_type", ["intensity", "probability", "debug", "debug"],
                "--task_name", ['graph', 'graph', 'graph', 'spearman_and_l1']
            ]
        }
    }
}

training_hyperparameter = {
    'real': realworld_training_hyperparameter_list,
    'syn': syn_training_hyperparameter_list
}

plot_hyperparameter = {
    'real': realworld_plot_hyperparameter_list,
    'syn': syn_plot_hyperparameter_list
}