#!/bin/bash
#SBATCH --job-name=case-study
#SBATCH --partition=SCT

#SBATCH --gres=gpu:1,
#SBATCH --cpus-per-task=8
#SBATCH --mem=32G
#SBATCH --qos=normal
#SBATCH --output=R-out_%j.txt
#SBATCH --error=R-err_%j.txt

# Yelp

# python3 case_study.py --dataset yelp --seq_x 10 --seq_h 25 --batch_size 128 --model_name ehd_perplexity
# python3 case_study.py --dataset yelp --seq_x 10 --seq_h 30 --batch_size 128 --model_name ehd_perplexity
# python3 case_study.py --dataset yelp --seq_x 10 --seq_h 35 --batch_size 128 --model_name ehd_perplexity
# python3 case_study.py --dataset yelp --seq_x 15 --seq_h 35 --batch_size 128 --model_name ehd_perplexity
# python3 case_study.py --dataset yelp --seq_x 20 --seq_h 35 --batch_size 128 --model_name ehd_perplexity

# python3 case_study.py --dataset yelp --seq_x 10 --seq_h 25 --batch_size 128 --model_name ehd_perplexity_hlhd
# python3 case_study.py --dataset yelp --seq_x 10 --seq_h 30 --batch_size 128 --model_name ehd_perplexity_hlhd
# python3 case_study.py --dataset yelp --seq_x 10 --seq_h 35 --batch_size 128 --model_name ehd_perplexity_hlhd
# python3 case_study.py --dataset yelp --seq_x 15 --seq_h 35 --batch_size 128 --model_name ehd_perplexity_hlhd
# python3 case_study.py --dataset yelp --seq_x 20 --seq_h 35 --batch_size 128 --model_name ehd_perplexity_hlhd

# Stackoverflow

# python3 case_study.py --dataset stackoverflow --seq_x 15 --seq_h 40 --batch_size 128 --model_name ehd_perplexity
# python3 case_study.py --dataset stackoverflow --seq_x 15 --seq_h 45 --batch_size 128 --model_name ehd_perplexity
# python3 case_study.py --dataset stackoverflow --seq_x 15 --seq_h 50 --batch_size 128 --model_name ehd_perplexity
# python3 case_study.py --dataset stackoverflow --seq_x 20 --seq_h 50 --batch_size 128 --model_name ehd_perplexity
# python3 case_study.py --dataset stackoverflow --seq_x 25 --seq_h 50 --batch_size 128 --model_name ehd_perplexity

# python3 case_study.py --dataset stackoverflow --seq_x 15 --seq_h 40 --batch_size 128 --model_name ehd_perplexity_hlhd
# python3 case_study.py --dataset stackoverflow --seq_x 15 --seq_h 45 --batch_size 128 --model_name ehd_perplexity_hlhd
# python3 case_study.py --dataset stackoverflow --seq_x 15 --seq_h 50 --batch_size 128 --model_name ehd_perplexity_hlhd
python3 case_study.py --dataset stackoverflow --seq_x 20 --seq_h 50 --batch_size 128 --model_name ehd_perplexity_hlhd
python3 case_study.py --dataset stackoverflow --seq_x 25 --seq_h 50 --batch_size 128 --model_name ehd_perplexity_hlhd

# Retweet
# python3 case_study.py --dataset retweet --seq_x 10 --seq_h 25 --batch_size 256 --model_name ehd_perplexity
# python3 case_study.py --dataset retweet --seq_x 10 --seq_h 30 --batch_size 256 --model_name ehd_perplexity
# python3 case_study.py --dataset retweet --seq_x 10 --seq_h 35 --batch_size 256 --model_name ehd_perplexity
# python3 case_study.py --dataset retweet --seq_x 15 --seq_h 35 --batch_size 256 --model_name ehd_perplexity
# python3 case_study.py --dataset retweet --seq_x 20 --seq_h 35 --batch_size 256 --model_name ehd_perplexity

# python3 case_study.py --dataset retweet --seq_x 10 --seq_h 25 --batch_size 256 --model_name ehd_perplexity_hlhd
# python3 case_study.py --dataset retweet --seq_x 10 --seq_h 30 --batch_size 256 --model_name ehd_perplexity_hlhd
# python3 case_study.py --dataset retweet --seq_x 10 --seq_h 35 --batch_size 256 --model_name ehd_perplexity_hlhd
# python3 case_study.py --dataset retweet --seq_x 15 --seq_h 35 --batch_size 256 --model_name ehd_perplexity_hlhd
# python3 case_study.py --dataset retweet --seq_x 20 --seq_h 35 --batch_size 256 --model_name ehd_perplexity_hlhd
