#!/usr/bin/env python
# coding: utf-8

# In[3]:


import pandas as pd
import numpy as np
import os, glob, json, yaml, io, math


# In[4]:


root = './data'
datasets_dir = 'TPP'

root = os.path.join(root, datasets_dir)
# datasets = os.listdir(root)
datasets = ['volcano']


# In[5]:


for dataset in datasets:
    print(f'Processing {dataset}...')
    dataset_dir = os.path.join(root, dataset)

    # load the property card
    f_property = open(os.path.join(dataset_dir, 'dataset_card.yml'), 'r')
    dataset_card = yaml.safe_load(f_property)
    f_property.close()

    file_names = [os.path.basename(item) for item in glob.glob(dataset_dir + f'/*.json')]
    max_time = 0
    min_time = 1e9
    for file_name in file_names:
        f_data = open(os.path.join(dataset_dir, file_name), 'r')
        dataset_json = json.load(f_data)
        f_data.close()

        df_dataset = pd.DataFrame.from_dict(dataset_json)
        list_time_seq = df_dataset.time_seq.tolist()
        del df_dataset
        max_time_of_this_dataset = 0
        min_time_of_this_dataset = 1e9
        for item in list_time_seq:
            tmp_max = max(item)
            tmp_min = min(item)
            if tmp_max > max_time_of_this_dataset:
                max_time_of_this_dataset = tmp_max
            else:
                continue

            if tmp_min < min_time_of_this_dataset:
                min_time_of_this_dataset = tmp_min
            else:
                continue

        if max_time > max_time_of_this_dataset:
            continue
        else:
            max_time = max_time_of_this_dataset
    
        if min_time < min_time_of_this_dataset:
            continue
        else:
            min_time = min_time_of_this_dataset

    max_time += 1.0
    min_time -= 1.0
    dataset_card['t_0'] = max(round(min_time), 0)
    dataset_card['T'] = round(max_time)

    with io.open(os.path.join(dataset_dir, 'dataset_card.yml'), 'w', encoding = 'utf8') as outfile:
        yaml.dump(dataset_card, outfile, default_flow_style=False, allow_unicode=True)


# In[ ]:




