import pickle
import math
import numpy as np


def compress_model(ckpt_path, path="safe_expert.npz", remove_value_network=False, save_weighs=True):
    with open(ckpt_path, "rb") as f:
        data = f.read()
    unpickled = pickle.loads(data)
    worker = pickle.loads(unpickled.pop("worker"))
    if "_optimizer_variables" in worker["state"]["default_policy"]:
        worker["state"]["default_policy"].pop("_optimizer_variables")
    pickled_worker = pickle.dumps(worker)
    weights = worker["state"]["default_policy"]
    for i in weights.keys():
        print(i)
        print(weights[i].shape)
    if remove_value_network:
        weights = {k: v for k, v in weights.items() if "value" not in k}
    if save_weighs:
        np.savez_compressed(path, **weights)
        print("Numpy agent weight is saved at: {}!".format(path))
    return weights

