## The repo is the official implementation for the paper: "Adaptive Energy Amplification for Robust Time Series Forecasting"

## Usage

1. Install Python 3.8. For convenience, execute the following command.

```
pip install -r requirements.txt
```

2. Prepare Data. You can obtain the well pre-processed datasets from the "Supplementary Material" or TimesNet, Then place the downloaded data in the folder`./dataset`.

3. Train and evaluate model. We provide the experiment scripts for ETTh1 under the folder `./scripts/`. You can reproduce the experiment results as the following examples:

```
# Backbone
bash ./scripts/ETTh1_backbone.sh
# Our Method
bash ./scripts/ETTh1_enhancer.sh
```

4. The source code of AEA is in `./layers/Energy.py`.

5. Develop your own model.

- Add the model file to the folder `./models`. You can follow the `./models/Transformer.py`.
- Include the newly added model in the `Exp_Basic.model_dict` of  `./exp/exp_basic.py`.
- Create the corresponding scripts under the folder `./scripts`.
 