#!/bin/bash

# Exit immediately if a command exits with a non-zero status
set -e

architectures=("graphsage") #"graphsage" "gcn" "sgc" "gat" "gin"
datasets=("cora") # "citeseer" "pubmed" "computers" "photo" "CS" "physics" flickr" "ogbn-arxiv" "reddit"
# Modify below edge ratio to test edge-restoraion
edge_ratios=(1.0) # 0.6  
pp_methods=("advanced")  # simple # Both ER-Basic and ER-advanced can be test

# Define the step to be performed; modify this line to change the step
step="all" # "train" "post-process" "all"

# Iterate over all combinations of parameters
for edge_ratio in "${edge_ratios[@]}"; do
  for architecture in "${architectures[@]}"; do
    for dataset in "${datasets[@]}"; do
      if [[ "$step" == "train" || "$step" == "all" ]]; then
        # For training step, skip loops for pp_method
        cmd="python main.py --architecture $architecture --dataset $dataset --edge_ratio $edge_ratio --step train"
        
        # Print and run the command
        echo "Running: $cmd"
        eval $cmd
      fi
      if [[ "$step" == "post-process" || "$step" == "all" ]]; then
        # For steps other than "train", include pp_method
        for pp_method in "${pp_methods[@]}"; do
          cmd="python main.py --architecture $architecture --dataset $dataset --edge_ratio $edge_ratio --pp_method $pp_method --step post_process"
                        # Print and run the command
          echo "Running: $cmd"
          eval $cmd
        done
      fi
    done
  done
done